#ifndef CGI_CGI_H
#define CGI_CGI_H

#include <stdio.h>
#include <cgi/cgi_config.h>
#include <cgi/cookies.h>
#include <cgi/headers.h>
#include <cgi/session.h>
#include <cgi/form.h>

//#include <dmalloc.h>

#if defined(CGI_WITH_FASTCGI)
#	include <fcgiapp.h>
//#	include <cgi/fcgi_streams.h>
#else
#	define FCGX_Request	void
#endif

struct s_cgi_context
{
	struct s_cookies *cookies;
	struct s_session *session;
	struct s_headers *headers;
	struct s_form	 *form;
	char **envp;
	FILE *in;
	FILE *out;
	int	 is_fcgi;

	FILE *__system_out;
	int	 __ob_enabled;
	void **ob_buffer;
	long  *ob_content_length;
};

typedef struct s_cgi_context t_cgi_context;

BEGIN_CDECL

t_cgi_context *cgi_context_create(FCGX_Request *);
void cgi_context_free(t_cgi_context *);
char *cgi_getenv(t_cgi_context *, char *);

END_CDECL

#endif
