#ifndef CGI_COOKIES_PARSER_H
#define CGI_COOKIES_PARSER_H

#include <time.h>

#include <cgi/cgi_config.h>
#include <cgi/headers.h>

struct s_cgi_context;

struct s_in_cookie
{
	char *name;
	char *value;
	struct s_in_cookie *next;
};

struct s_out_cookie
{
	char *name;
	char *value;
	time_t timeout;
	struct s_http_header *associated_header;
	struct s_out_cookie *next;
};

struct s_cookies
{
	struct s_out_cookie *server_cookies;
	struct s_in_cookie *client_cookies;
	struct s_cgi_context *cgi_ctx;
};

typedef struct s_cookies t_cookies;

/*
 * Note, that functions return copy of objects, therefore you can
 * do with them whatever you want, but you will have to free it 
 * after use.
 */

BEGIN_CDECL

int cookies_parse(t_cookies *);
int cookie_set(struct s_cgi_context *, char *, char *, time_t, char *);
int cookie_unset(struct s_cgi_context *, char *);
char *cookie_get(struct s_cgi_context *, char *);

void free_client_cookies(struct s_in_cookie *);
void free_server_cookies(struct s_out_cookie *);
t_cookies *cookies_create();
void cookies_free(t_cookies *);

END_CDECL

#endif
