#ifndef CGI_FORM_COLLECTOR_H
#define CGI_FORM_COLLECTOR_H

#include <cgi/cgi_config.h>

/*
 * POST_VAR registers new post variable.
 * GET_VAR does the same with get variables.
 */

#define	POST_VAR(form, var_name) struct s_form_field *var_name = \
								form_register_post_var(form, #var_name, &var_name)
#define	GET_VAR(form, var_name)	struct s_form_field *var_name = \
								form_register_get_var(form, #var_name, &var_name)

struct s_cgi_context;

struct s_form_field
{
	char *name;
	union
	{
		char *data;
		struct s_form_field **array;
	}	data;
#define	ff_data		data.data
#define	ff_array	data.array
	long length;
#define array_size	length
	char *content_type;
	int	 is_file;
	int	 is_array;
} t_form_field;

struct s_form_var
{
	char	*name;				// variable name
	struct	s_form_field **ptr;	// pointer to variable
	struct	s_form_field *field;  // pointer to field
	struct	s_form_var *next;		// pointer to next list entry
};

struct s_form_field_list
{
	struct	s_form_field	*field;	// pointer to field
	struct	s_form_field_list	*next;	// pointer to next list entry
};

struct s_form
{
	struct s_form_field_list *GET;
	struct s_form_field_list *POST;
	
	struct s_form_var *GET_vars;
	struct s_form_var *POST_vars;

	struct s_cgi_context *cgi_ctx;
};

typedef struct s_form t_form;

BEGIN_CDECL

struct s_form_field *form_register_post_var(struct s_cgi_context *, char *, struct s_form_field **);
struct s_form_field *form_register_get_var(struct s_cgi_context *, char *name, struct s_form_field **ptr);
struct s_form_field *form_field(struct s_cgi_context *, char *name);
struct s_form_field *form_get_field(struct s_cgi_context *, char *name);
struct s_form_field *form_post_field(struct s_cgi_context *, char *name);
struct s_form_field *form_field_copy(struct s_form_field *field);
void form_field_free(struct s_form_field *field);
int  form_parse_data(t_form *);
void form_free_data(t_form *);
t_form *form_create();
void form_free(t_form *);

END_CDECL

#endif
