#ifndef FORM_PARSER_H
#define FORM_PARSER_H

#include <stdio.h>

#include <cgi/cgi_config.h>
#include "parser.h"

#define GET_DATA	1
#define POST_DATA	2

#define	E_OK				0
#define	E_NOMEM				1
#define	E_CORRUPT			2
#define	E_NODATA			4
#define E_NOTINITIALIZED	5
#define E_DATATOOBIG		6
#define E_HEADERTOOBIG		7

#ifndef	INTERNALS_DEFINED
#define INTERNALS_DEFINED

struct FP_INTERNALS
{
	/*
	 * Don't even try to touch those variables - though they look messy, they are all needed to
	 * correctly parse input data!
	 */
	long lreserved[3];
	int  ireserved[8];
	char *creserved[2];
};

#endif

struct FORM_PARSER
{
	char *field_name;
	char *field_data;
	char *file_name;
	char *content_type;
	long field_length;
	int  is_file;
	int  is_last;
	FILE *in;
	char **envp;

	struct PARSER_ERROR_INFO _error_info;
#define corrupted		_error_info._corrupt_info._corrupted
#define is_corrupted	_error_info._corrupt_info._is_corrupted
#define parser_error	_error_info._error

	struct FORM_PARSER_CONFIG
	{
		char *buffer;
		int  buffer_size;
		char *boundary;
		int  max_size;
		int  always_read_header;
		int	 auto_boundary;
	} config;

	struct FP_INTERNALS internal;
};

BEGIN_CDECL

struct FORM_PARSER *create_form_parser(void);
void destroy_form_parser(struct FORM_PARSER *parser);
void clear_form_parser(struct FORM_PARSER *parser);
void init_form_parser(struct FORM_PARSER *parser, int);
void reset_form_parser(struct FORM_PARSER *parser);
int parse_form_urlencoded(struct FORM_PARSER *parser);
int parse_form_multipart(struct FORM_PARSER *parser);
int parse_post_data(struct FORM_PARSER *parser);
int parse_get_data(struct FORM_PARSER *parser);

END_CDECL

#endif
