#ifndef CGI_HEADERS_H
#define CGI_HEADERS_H

#include <cgi/cgi_config.h>

struct s_cgi_context;

struct s_http_header
{
	char *name;
	char *value;
	struct s_http_header *next;
};

struct s_headers
{
	struct s_http_header *headers;
	struct s_cgi_context *cgi_ctx;

	int are_sent;
};

typedef struct s_http_header t_http_header;
typedef struct s_headers t_headers;

BEGIN_CDECL

struct s_http_header *header_add(struct s_cgi_context *ctx, char *name, char *value);
struct s_http_header *header_set(struct s_cgi_context *ctx, char *name, char *value);
struct s_http_header *header_get(struct s_cgi_context *ctx, char *name);
void headers_out(struct s_cgi_context *ctx);

struct s_headers *headers_create(void);
void headers_free(struct s_headers *headers);

END_CDECL

#endif
