#ifndef CGI_SESSION_H
#define CGI_SESSION_H

#include <sys/time.h>
#include <cgi/cgi_config.h>

#ifndef SESSION_TIMEOUT
#	define SESSION_TIMEOUT 900
#endif

#ifndef SESSION_COOKIE
#	define SESSION_COOKIE	"_sessid"
#endif

#ifndef GC_PROB
#	define GC_PROB	1/50
#endif

struct s_cgi_context;

struct s_session;
struct s_serialized;

typedef void (*t_serializer)(struct s_serialized *, void *var);
typedef void (*t_deserializer)(struct s_serialized *, void *var);

typedef int (*session_media_load)	(struct s_session*, char *, struct s_serialized*);
typedef int (*session_media_save)	(struct s_session*, char *, struct s_serialized*);
typedef int	(*session_media_open)	(struct s_session*);
typedef int	(*session_media_close)	(struct s_session*);
typedef int	(*session_media_clean)	(struct s_session*);
typedef int	(*session_media_destroy)(struct s_session*);
typedef int	(*session_media_check)	(struct s_session*);
typedef int	(*session_media_gc)		(struct s_session*);

struct s_serialized
{
	char *name;
	size_t size;
	void *data;
	struct s_serialized *next;
};

struct s_session_var
{
	char *name;
	void *var;
	t_serializer serialize;
	t_deserializer deserialize;
	struct s_session_var *next;
};

struct s_session_handler
{
	session_media_load		load_var;
	session_media_save		save_var;
	session_media_open		stream_open;
	session_media_close		stream_close;
	session_media_clean		stream_clean;
	session_media_destroy	stream_destroy;
	session_media_check		stream_exists;
	session_media_gc		collect_garbage;
};

struct s_session
{
	void *stream;

	struct s_session_handler *handler;
	
	char *sessid;
	int is_new;
	struct s_serialized *saved_vars;
	struct s_session_var *vars;
	int error;
	long timeout;
	struct s_cgi_context *cgi_ctx;
};

typedef struct s_session t_session;
typedef struct s_session_handler t_session_handler;
typedef struct s_session_var t_session_var;
typedef struct s_serialized t_serialized;

BEGIN_CDECL

void session_register_var(struct s_cgi_context *ctx, char *name, void *var_ptr, 
							t_serializer serializer, t_deserializer deserializer);
#define SESSION_REGISTER(session, var, serializer, deserializer) \
				session_register_var(session, #var, &var, serializer, deserializer)

t_session *session_create(void);
t_session *session_start(struct s_cgi_context *ctx);
void session_timeout(struct s_cgi_context *ctx, long timeout);
void session_save(t_session *);
void session_free(t_session *);

END_CDECL

#include <cgi/sess_stdtype.h>
//#include <cgi/sess_file.h>

#endif
