#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <cgi/utils.h>
#include <cgi/cgi.h>
#include <cgi/cgi_error.h>
#include <cgi/cgi_thread.h>
#include <cgi/cookies.h>

#include <osdep.h>

inline struct s_in_cookie *create_client_cookie()
{
	struct s_in_cookie *cookie;

	cookie = malloc(sizeof(struct s_in_cookie));
	
	if(cookie)
		memset(cookie, 0, sizeof(struct s_in_cookie));

	return cookie;
};

inline struct s_out_cookie *create_server_cookie()
{
	struct s_out_cookie *cookie;

	cookie = malloc(sizeof(struct s_out_cookie));

	if(cookie)
		memset(cookie, 0, sizeof(struct s_out_cookie));

	return cookie;
}

int cookies_parse(t_cookies *cookies)
{
	struct s_in_cookie *cookie, **last_cookie = &cookies->client_cookies;
	char *http_cookies, *name, *value, *divider;
	long len;
	register char *s_cookie;

	// Maybe it is better to strdup it to avoid changing it while parsing
	// if it is possible.
	http_cookies = fast_get_env(cookies->cgi_ctx->envp, "HTTP_COOKIE");

	if(!http_cookies)
		return CGI_ERROR;

	s_cookie = http_cookies;

	if(cookies->client_cookies)
		free_client_cookies(cookies->client_cookies);

	while(s_cookie) 
	{
		name = s_cookie;
		
		while(*s_cookie && (*s_cookie != '='))
		{
			s_cookie ++;
		}

		divider = value = s_cookie;

		if(!*s_cookie++)
			break;

		cookie = create_client_cookie();

//		len = ((long)s_cookie - (long)name);
//		cookie->name = malloc(len);
//		memcpy(cookie->name, name, len);
//		cookie->name[len-1] = 0;
//		divider = value = s_cookie;

		while(*s_cookie && (*s_cookie != ';'))
		{
			s_cookie ++;
		}

//		len = ((long)s_cookie - (long)value);
		len = ((long)s_cookie - (long)name);
		cookie->name = malloc(len);
		*divider = '\0';
		memcpy(cookie->name, name, len);
		*divider = '=';
		cookie->value = cookie->name + (divider - name) + 1;//malloc(len+1);
//		memcpy(cookie->value, value, len);
//		cookie->value[len] = 0;
		cookie->name[len] = 0;

		*last_cookie = cookie;
		last_cookie = &(cookie->next);

		if(!*(s_cookie++))
			break;

		while(*s_cookie && (*s_cookie == ' ')) 
		{
			s_cookie ++;
		}
	}

	return CGI_OK;
};

int cookie_set(struct s_cgi_context *ctx, char *name, char *value, time_t timeout, char *path)
{
	t_cookies *cookies = ctx->cookies;
	struct s_out_cookie *cookie, *tmp;
	char *cookie_string, *stmp;
	int namelen, valuelen, pathlen;

	namelen = strlen(name);
	valuelen = strlen(value);

	if(path)
	{
		pathlen = strlen(path);
		
		if(!(cookie_string = malloc(namelen + valuelen + pathlen + 9)))
		{
			return CGI_ERROR;
		}

		memcpy(cookie_string, name, namelen);
		memcpy(cookie_string + namelen, "=", sizeof("="));
		memcpy(cookie_string + namelen + sizeof("=")-1, value, valuelen);
		memcpy(cookie_string + namelen + sizeof("=")-1 + valuelen, "; path=", sizeof("; path=")-1);
		memcpy(cookie_string + namelen + sizeof("=")-1 + valuelen + sizeof("; path=")-1, path, pathlen);
		cookie_string[namelen + sizeof("=")-1 + valuelen + sizeof("; path=")-1 + pathlen] = '\0';
/*		if(asprintf(&cookie_string, "%s=%s; path=%s", name, value, path) < 0)
		{
			return CGI_ERROR;
		}*/
	}
	else
	{
		if(!(cookie_string = malloc(namelen + valuelen + 10)))
		{
			return CGI_ERROR;
		}

		memcpy(cookie_string, name, namelen);
		memcpy(cookie_string + namelen, "=", sizeof("=")-1);
		memcpy(cookie_string + namelen + sizeof("=")-1, value, valuelen);
		memcpy(cookie_string + namelen + sizeof("=")-1 + valuelen, "; path=/", sizeof("; path=/")-1);
		cookie_string[namelen + sizeof("=")-1 + valuelen + sizeof("; path=/")-1] = '\0';
/*		if(asprintf(&cookie_string, "%s=%s; path=/", name, value) < 0)
		{
			return CGI_ERROR;
		}*/
	}

	if(timeout >= 0)
	{
		stmp = cookie_string;

		if(asprintf(&cookie_string, "%s; Max-Age=%ld", stmp, (long)timeout) < 0)
		{
			free(stmp);
			return CGI_ERROR;
		}
		
		free(stmp);
	}

	tmp = cookies->server_cookies;

	if(tmp)
		while(tmp->next)
		{
			if(strcasecmp(tmp->name, name))
			{
				free(tmp->associated_header->value);
				tmp->associated_header->value = strdup(cookie_string);
				tmp->timeout = timeout;
				return CGI_OK;
			}
		}

	cookie = create_server_cookie();
	cookie->name = strdup(name);
	cookie->value = strdup(value);
	cookie->timeout = timeout;

	if(cookies->cgi_ctx)
		cookie->associated_header = header_add(ctx, "Set-Cookie", cookie_string);

	if(tmp)
		tmp->next = cookie;
	else
		cookies->server_cookies = cookie;

	free(cookie_string);

	return CGI_OK;
};

int cookie_unset(struct s_cgi_context *ctx, char *name)
{
	return cookie_set(ctx, name, "", 0, NULL);
};

char *cookie_get(struct s_cgi_context *ctx, char *name)
{
	t_cookies *cookies = ctx->cookies;
	struct s_in_cookie *tmp;

	tmp = cookies->client_cookies;
	
	while(tmp)
	{
		if(!strcasecmp(tmp->name, name))
		{
			return tmp->value;
		}

		tmp = tmp->next;
	}

	return NULL;
};

void free_client_cookies(struct s_in_cookie *client_cookies)
{
	struct s_in_cookie *cookie, *tmp;

	cookie = client_cookies;
	while(cookie)
	{
		tmp = cookie->next;
		if(cookie->name)
			free(cookie->name);
//		if(cookie->value)
//			free(cookie->value);
		free(cookie);
		cookie = tmp;
	}
	
	client_cookies = NULL;
};

void free_server_cookies(struct s_out_cookie *server_cookies)
{
	struct s_out_cookie *cookie, *tmp;

	cookie = server_cookies;

	while(cookie)
	{
		tmp = cookie->next;

		if(cookie->name)
			free(cookie->name);

		if(cookie->value)
			free(cookie->value);

		free(cookie);
		cookie = tmp;
	}
};

struct s_cookies *cookies_create()
{
	struct s_cookies *cookies;
	
	cookies = malloc(sizeof(struct s_cookies));
	if(cookies)
		memset(cookies, 0, sizeof(struct s_cookies));

	return cookies;
};

void cookies_free(t_cookies *cookies)
{
	free_client_cookies(cookies->client_cookies);
	free_server_cookies(cookies->server_cookies);
	free(cookies);
};
