#include <stdio.h>
#include <fcgiapp.h>

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#ifdef WITH_FCGI

int fcgi_reader(void *, char *, int);
int fcgi_writer(void *, const char *, int);
int fcgi_closer(void *);

FILE *fcgi_open(FCGX_Stream *stream)
{
	FILE *result;
#ifdef HAVE_FUNOPEN
	result = funopen(stream, &fcgi_reader, &fcgi_writer, NULL, &fcgi_closer);
#else
#	ifdef HAVE_FOPENCOOKIE
	cookie_io_functions_t  fcgi_func = {
		.read = &fcgi_reader,
		.write = &fcgi_writer,
		.seek = NULL,
		.close = &fcgi_closer
	};

	result = fopencookie(stream, "rw", &fcgi_func);
#	else
#		error	"Your system does not have either funopen or fopencookie function - no FCGI support available"
#	endif
#endif
	return result;
};

int fcgi_reader(void *stream, char *buffer, int len)
{
	return FCGX_GetStr(buffer, len, (FCGX_Stream*)stream);
};

int fcgi_writer(void *stream, const char *buffer, int len)
{
	return FCGX_PutStr(buffer, len, (FCGX_Stream*)stream);
};

int fcgi_closer(void *stream)
{
	return FCGX_FFlush((FCGX_Stream*)stream);
};

#endif
