#include <stdlib.h>
#include <string.h>
#include <cgi/cgi.h>
#include <cgi/form_parser.h>
#include <cgi/cgi_error.h>
#include <cgi/form.h>

int form_append_field(struct s_form_field_list *where, struct s_form_field *what);
struct s_form_field_list *form_field_list_create(void);
void form_field_list_free(struct s_form_field_list *item);
struct s_form_field *form_field_create(void);
struct s_form_var	*form_var_create(void);
void form_append_var(struct s_form_var *where, struct s_form_var *what);

// Fields subroutines

struct s_form_field *form_field_create()
{
	struct s_form_field	*field;

	field = malloc(sizeof(struct s_form_field));

	if(field)
		memset(field, 0, sizeof(struct s_form_field));

	return field;
}

void form_field_free(struct s_form_field *field)
{
	int i;

	if(!field)
		return;

	if(field->name)
		free(field->name);
	
	if(field->is_array)
		if(field->ff_array)
			for(i = 0; i < field->array_size; i ++)
				form_field_free(field->ff_array[i]);
	
	if(field->ff_data)
		free(field->ff_data);

	free(field);
}

struct s_form_field *form_field_copy(struct s_form_field *field)
{
	struct s_form_field *new_field;
	int i;

	new_field = form_field_create();

	if(field->name)
		new_field->name = strdup(field->name);

	if(field->content_type)
		new_field->content_type = strdup(field->content_type);

	new_field->is_array = field->is_array;
	new_field->is_file = field->is_file;
	new_field->length = field->length;

	if(field->is_array)
	{
		new_field->ff_array = malloc(sizeof(struct s_form_field*) * new_field->array_size);

		for(i = 0; i < new_field->array_size; i ++)
		{
			new_field->ff_array[i] = form_field_copy(field->ff_array[i]);
		}
	}
	else
	{
		new_field->ff_data = malloc(new_field->length);
		memcpy(new_field->ff_data, field->ff_data, field->length);
	}
	return new_field;
}

// Field list processing

struct s_form_field_list *form_field_list_create()
{
	struct s_form_field_list *field;

	field = malloc(sizeof(struct s_form_field_list));

	if(field)
		memset(field, 0, sizeof(struct s_form_field_list));

	return field;
}

void form_field_list_free(struct s_form_field_list *item)
{
	if(!item)
		return;

	form_field_free(item->field);

	free(item);
}

int form_append_field(struct s_form_field_list *where, struct s_form_field *what)
{
	struct s_form_field_list *current = where;
	struct s_form_field *array_item, **tmp;

	while(current)
	{
		if(!strcasecmp(current->field->name, what->name))
		{
			if(current->field->is_array)
			{
				if(current->field->array_size < 0)
					return CGI_ERROR;
			
				tmp = realloc(current->field->ff_array, sizeof(struct s_form_field *) * 
													(current->field->array_size + 1));
				if(!tmp)
					return CGI_ERROR;
				
				current->field->ff_array = tmp;
				current->field->array_size ++;
				current->field->ff_array[current->field->array_size - 1] = what;
			}
			else
			{
				if(!(array_item = form_field_create()))
					return CGI_ERROR;
				
				if(!(array_item->name = strdup(current->field->name)))
				{
					free(array_item);
					return CGI_ERROR;
				}
				
				array_item->is_array = 1;
				array_item->ff_array = malloc(sizeof(struct s_form_field*) * 2);
				array_item->array_size = 2;
				array_item->ff_array[0] = current->field;
				array_item->ff_array[1] = what;
				current->field = array_item;
			}
			return CGI_OK;
		}

		if(!current->next)
		{
			break;
		}

		current = current->next;
	}
	current->next = form_field_list_create();
	current->next->field = what;
	return CGI_OK;
};

// Variables handling

struct s_form_var *form_var_create()
{
	struct s_form_var *var;

	var = malloc(sizeof(struct s_form_var));

	if(var)
		memset(var, 0, sizeof(struct s_form_var));

	return var;
};

void form_append_var(struct s_form_var *where, struct s_form_var *what)
{
	struct s_form_var *current = where;

	while(current->next)
	{
		current = current->next;
	}

	current->next = what;
}

void form_var_free(struct s_form_var *var)
{
	if(!var)
		return;

	if(var->name)
		free(var->name);

	if(var->field)
		form_field_free(var->field);

	free(var);
}

#define TEMPORARY_BUFFER_SIZE	1024
int form_parse_data(struct s_form *form)
{
	struct FORM_PARSER	*parser = create_form_parser();
	struct s_form_field	*field;
	struct s_form_field_list *list;
	struct s_form_var *var;


	parser->config.buffer = malloc(TEMPORARY_BUFFER_SIZE);
	parser->config.buffer_size = TEMPORARY_BUFFER_SIZE;
	parser->config.auto_boundary = 1;
	parser->in = form->cgi_ctx->in;
	parser->envp = form->cgi_ctx->envp;
	
	init_form_parser(parser, GET_DATA);
	
	if(parser->parser_error)
	{
		return CGI_ERROR;
	}

	while(parse_get_data(parser))
	{
		if(!parser->parser_error)
		{
			if(!(field = form_field_create()))
			{
				return CGI_ERROR;
			}

			field->name = strdup(parser->field_name);
			field->is_file = parser->is_file;
			field->length = parser->field_length;

			if(!parser->is_file)
				field->length ++;

			field->ff_data = malloc(field->length);
			memset(field->ff_data, 0, field->length);
			memcpy(field->ff_data, parser->field_data, parser->field_length);

			if(!form->GET)
			{
				if(!(form->GET = form_field_list_create()))
					return CGI_ERROR;
				form->GET->field = field;
			}
			else
				form_append_field(form->GET, field);
		}
		else
		{
			return CGI_ERROR;
		}
	}

	init_form_parser(parser, POST_DATA);

	while(parse_post_data(parser))
	{
		if(!parser->parser_error)
		{
			if(!(field = form_field_create()))
			{
				return CGI_ERROR;
			}

			field->name = strdup(parser->field_name);
			field->is_file = parser->is_file;
			field->length = parser->field_length;

			if(!parser->is_file)
				field->length ++;

			field->ff_data = malloc(field->length);
			memset(field->ff_data, 0, field->length);
			memcpy(field->ff_data, parser->field_data, parser->field_length);

			if(!form->POST)
			{
				if(!(form->POST = form_field_list_create()))
					return CGI_ERROR;

				form->POST->field = field;
			}
			else
				form_append_field(form->POST, field);
		}
	}

	free(parser->config.buffer);
	destroy_form_parser(parser);

	// Search for registered variables

	var = form->GET_vars;

	while(var)
	{
		var->field = *(var->ptr) = NULL;
		list = form->GET;
		while(list)
		{
			if(!strcasecmp(var->name, list->field->name))
			{
				var->field = *(var->ptr) = form_field_copy(list->field);
				break;
			}

			list = list->next;
		}

		var = var->next;
	}

	var = form->POST_vars;

	while(var)
	{
		var->field = *(var->ptr) = NULL;
		list = form->POST;
		while(list)
		{
			if(!strcasecmp(var->name, list->field->name))
			{
				var->field = *(var->ptr) = form_field_copy(list->field);
				break;
			}

			list = list->next;
		}

		var = var->next;
	}

	return CGI_OK;
};

void form_free_data(struct s_form *form)
{
	struct s_form_field_list	*list, *tmp;
	struct s_form_var		*var, *tvar;

	list = form->GET;

	while(list)
	{
		tmp = list->next;
		form_field_list_free(list);
		list = tmp;
	}

	list = form->POST;

	while(list)
	{
		tmp = list->next;
		form_field_list_free(list);
		list = tmp;
	}

	var = form->GET_vars;

	while(var)
	{
		tvar = var->next;
		form_var_free(var);
		var = tvar;
	}

	var = form->POST_vars;

	while(var)
	{
		tvar = var->next;
		form_var_free(var);
		var = tvar;
	}
};

struct s_form_field *form_register_post_var(struct s_cgi_context *ctx, char *name, struct s_form_field **ptr)
{
	struct s_form *form = ctx->form;
	struct s_form_var	*var;
	struct s_form_field_list *list;

	var = form_var_create();
	var->name = strdup(name);
	var->ptr = ptr;

	if(!form->POST_vars)
		form->POST_vars = var;
	else
		form_append_var(form->POST_vars, var);

	var->field = *(var->ptr) = NULL;
	list = form->POST;

	while(list)
	{
		if(!strcasecmp(var->name, list->field->name))
		{
			var->field = *(var->ptr) = form_field_copy(list->field);
			return var->field;
		}

		list = list->next;
	}

	return NULL;
};

struct s_form_field *form_register_get_var(struct s_cgi_context *ctx, char *name, struct s_form_field **ptr)
{
	struct s_form *form = ctx->form;
	struct s_form_var	*var;
	struct s_form_field_list *list;

	var = form_var_create();
	var->name = strdup(name);
	var->ptr = ptr;

	if(!form->GET_vars)
		form->GET_vars = var;
	else
		form_append_var(form->GET_vars, var);

	var->field = *(var->ptr) = NULL;
	list = form->GET;

	while(list)
	{
		if(!strcasecmp(var->name, list->field->name))
		{
			var->field = *(var->ptr) = form_field_copy(list->field);
			return var->field;
		}

		list = list->next;
	}

	return NULL;
};

struct s_form_field *form_field(struct s_cgi_context *ctx, char *name)
{
	struct s_form *form = ctx->form;
	struct s_form_field_list *list = form->GET;

	while(list)
	{
		if(!strcasecmp(name, list->field->name))
		{
			return form_field_copy(list->field);
		}

		list = list->next;
	}

	list = form->POST;

	while(list)
	{
		if(!strcasecmp(name, list->field->name))
		{
			return form_field_copy(list->field);
		}

		list = list->next;
	}

	return NULL;
};

struct s_form_field *form_post_field(struct s_cgi_context *ctx, char *name)
{
	struct s_form *form = ctx->form;
	struct s_form_field_list *list = form->POST;

	while(list)
	{
		if(!strcasecmp(name, list->field->name))
		{
			return form_field_copy(list->field);
		}

		list = list->next;
	}

	return NULL;
};

struct s_form_field *form_get_field(struct s_cgi_context *ctx, char *name)
{
	struct s_form *form = ctx->form;
	struct s_form_field_list *list = form->GET;

	while(list)
	{
		if(!strcasecmp(name, list->field->name))
		{
			return form_field_copy(list->field);
		}

		list = list->next;
	}

	return NULL;
};

void form_free(struct s_form *form)
{
	form_free_data(form);
	free(form);
};

struct s_form * form_create()
{
	struct s_form *form;
	
	form = malloc(sizeof(struct s_form));
	
	if(form)
		memset(form, 0, sizeof(struct s_form));
	
	return form;
};

