#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cgi/cgi.h>
#include <cgi/cgi_error.h>
#include <cgi/cgi_thread.h>
#include <cgi/headers.h>

#define HDR_SIZE	sizeof(struct s_http_header)

struct s_http_header *header_create(char *name, char *value);
void header_free(t_http_header *hdr);

struct s_http_header *header_create(char *name, char *value)
{
	struct s_http_header *hdr;

	if(!name)
		return NULL;

	hdr = malloc(sizeof(struct s_http_header));

	if(!hdr)
		return NULL;

	memset(hdr, 0, sizeof(struct s_http_header));

	if(!(hdr->name = strdup(name)))
	{
		free(hdr);
		return NULL;
	}

	if(value)
		hdr->value = strdup(value);
	else
		hdr->value = strdup("");

	if(!hdr->value)
	{
		free(hdr->name);
		free(hdr);
		return NULL;
	}

	return hdr;
};

void header_free(struct s_http_header *hdr)
{
	if(!hdr)
		return;

	if(hdr->name)
		free(hdr->name);

	if(hdr->value)
		free(hdr->value);

	free(hdr);
}

t_http_header *header_add(struct s_cgi_context *ctx, char *name, char *value)
{
	struct s_headers *headers = ctx->headers;
	t_http_header *hdr;

	hdr = headers->headers;

	if(!hdr)
	{
		headers->headers = header_create(name, value);
		return headers->headers;
	}

	while(hdr->next)
	{
		hdr = hdr->next;
	}
	
	hdr->next = header_create(name, value);
	return hdr->next;
};

t_http_header *header_set(struct s_cgi_context *ctx, char *name, char *value)
{
	struct s_headers *headers = ctx->headers;
	t_http_header *hdr, *created;
	t_http_header **hdr_prev = &headers->headers;

	hdr = headers->headers;

	if(!hdr)
	{
		headers->headers = header_create(name, value);
		return headers->headers;
	}

	while(hdr)
	{
		if(!strcasecmp((*hdr_prev)->name, name))
		{
			if(!(created = header_create(name, value)))
			{
				return NULL;
			}

			created->next = (*hdr_prev)->next;
			header_free(*hdr_prev);
			*hdr_prev = created;
			return created;
		}
		hdr_prev = &((*hdr_prev)->next);
		hdr = hdr->next;
	}
	
	return *hdr_prev = header_create(name, value);
};

struct s_http_header *header_get(struct s_cgi_context *ctx, char *name)
{
	struct s_headers *headers = ctx->headers;
	t_http_header *hdr;

	hdr = headers->headers;

	if(!hdr)
		return NULL;

	while(hdr->next)
	{
		if(!strcasecmp(hdr->name, name))
		{
			return hdr;
		}

		hdr = hdr->next;
	}

	return NULL;
};

void headers_out(struct s_cgi_context *ctx)
{
	struct s_headers *headers = ctx->headers;
	t_http_header *hdr;

	hdr = headers->headers;

	if(!hdr)
		return;

	while(hdr)
	{
		fprintf(headers->cgi_ctx->__system_out, "%s: %s\r\n", hdr->name, hdr->value);
		hdr = hdr->next;
	}

	fprintf(headers->cgi_ctx->__system_out, "\r\n");
	headers->are_sent = 1;

	return;
};

struct s_headers *headers_create()
{
	struct s_headers *headers;
	
	headers = malloc(sizeof(struct s_headers));

	if(headers)
		memset(headers, 0, sizeof(struct s_headers));
	
	return headers;
};

void headers_free(struct s_headers *headers)
{
	
	t_http_header *hdr, *nxt;
	
	hdr = headers->headers;

	while(hdr)
	{
		nxt = hdr->next;
		header_free(hdr);
		hdr = nxt;
	}

	free(headers);
};

