#include <sys/types.h>                                                                                                        
#include <errno.h>                                                                                                            
#include <assert.h>                                                                                                           
#include <string.h>
#include <stdlib.h>                                                                                                           
#include <sys/types.h>                                                                                                        
#include <sys/uio.h>                                                                                                          
#include <unistd.h>                                                                                                           
#include <cgi/headers.h>
#include <cgi/ob_stream.h>

/******************************************************************************
 *
 ******************************************************************************/

int ob_stream_write (void *stream, const char *buffer, int size)
{
	struct s_ob_stream *s = (struct s_ob_stream *) stream;
	long written;
	int left = s->buffersize - s->datasize;

	if(size > left)
		s->buffer = (char *)realloc(s->buffer, (s->buffersize += (((size - left) / BUFFER_GROW_THRESHOLD + (((size - left) % BUFFER_GROW_THRESHOLD) ? 1 : 0)) * BUFFER_GROW_THRESHOLD)));

	if(size)
	 	memcpy(s->buffer + s->datasize, buffer, size);

	// Upon return from write()...
	s->datasize += size;

	if(s->cgi_ctx)
	{
		if(s->datasize && !s->cgi_ctx->__ob_enabled)
		{
			if(!s->cgi_ctx->headers->are_sent)
			{
				headers_out(s->cgi_ctx);
			}
			
			while(s->datasize)
			{
				written = fwrite(s->buffer, 1, s->datasize, s->cgi_ctx->__system_out);
				s->datasize -= written;
			}
		}
	}

	return size;
}

/******************************************************************************
 *
 ******************************************************************************/
int ob_stream_free (void *stream)
{                                                                                                                             
	struct s_ob_stream *s = (struct s_ob_stream *) stream;
	long written;

	if(s->cgi_ctx)
	{
		if(!s->cgi_ctx->headers->are_sent)
		{
			headers_out(s->cgi_ctx);
		}
		
		while(s->datasize)
		{
			written = fwrite(s->buffer, 1, s->datasize, s->cgi_ctx->__system_out);
			s->datasize -= written;
		}
	}

	if (s->buffer) 
	{
		free (s->buffer);
		s->datasize = s->buffersize = 0;                                                                                                  
	}                                                                                                                     

	free (stream);                                                                                                         
	return 0;
};

/******************************************************************************
 *
 ******************************************************************************/
struct s_ob_stream *ob_create()
{
	struct s_ob_stream *s = malloc (sizeof (struct s_ob_stream));
#ifdef __linux__
	cookie_io_functions_t  stream_func = {
		.read = NULL,
		.write = ob_stream_write,
		.seek = NULL,
		.close = ob_stream_free
	};
#endif

	struct s_ob_stream init =                                                                                                  
	{                                                                                                                     
#if defined( __FreeBSD__ )
		.file = funopen(s, NULL, ob_stream_write, NULL, ob_stream_free),
#else 
#	if defined( __linux__ )
		.file = fopencookie(stream, "rw", &stream_func),
#	else
#		error "Your system does not support custom stream API!"
#	endif
#endif
		.buffer = NULL, 
		.buffersize = 0, 
		.datasize = 0, 
		.cgi_ctx = NULL
	};

	if (s) 
		memcpy (s, &init, sizeof (struct s_ob_stream));

	return s;
};

/******************************************************************************
 *
 ******************************************************************************/
FILE *ob_open(struct s_cgi_context *ctx)
{
	struct s_ob_stream *s = ob_create();

	s->cgi_ctx = ctx;
	ctx->ob_buffer = (void**)&s->buffer;
	ctx->ob_content_length = &s->datasize;
	setvbuf(s->file, NULL, _IONBF, 0);

	return s->file;
}

void ob_enable(struct s_cgi_context *ctx)
{
	ctx->__ob_enabled = 1;
}

void ob_end_flush(struct s_cgi_context *ctx)
{
	ctx->__ob_enabled = 0;
	fwrite(*ctx->ob_buffer, 0, 0, ctx->out);
}

void ob_end_discard(struct s_cgi_context *ctx)
{
	*ctx->ob_content_length = 0;
	ctx->__ob_enabled = 0;
}

