#include <stdlib.h>
#include <string.h>
#include <cgi/session.h>
#include <cgi/sess_stdtype.h>

void serialize_int(struct s_serialized *s_val, void *var)
{
	int *value = var;

	s_val->size = sizeof(int);
	s_val->data = malloc(sizeof(int));
	
	if(s_val->data)
		*(int*)s_val->data = *value;
};

void deserialize_int(struct s_serialized *s_val, void *var)
{
	int *value = var;

	if(s_val->data)
		*value = *(int*)s_val->data;
};


void serialize_string(struct s_serialized *s_val, void *var)
{
	char **value = var;

	if(*value)
	{
		s_val->size = strlen(*value) + 1;
		s_val->data = malloc(s_val->size);

		if(s_val->data)
			memcpy(s_val->data, *value, s_val->size);
	}
	else
	{
		s_val->size = 1;
		s_val->data = malloc(s_val->size);

		if(s_val->data)
			*(char*)s_val->data = 1;
	}
};

void deserialize_string(struct s_serialized *s_val, void *var)
{
	char **value = var;

	if(s_val->size == 1)
	{
		if(*(char*)s_val->data == 1)
		{
			*value = NULL;
			return;
		}
	}

	if(s_val->data)
		*value = strdup((char*)s_val->data);
};


void serialize_long(struct s_serialized *s_val, void *var)
{
	long *value = var;

	s_val->size = sizeof(long);
	s_val->data = malloc(sizeof(long));
	
	if(s_val->data)
		*(long*)s_val->data = *value;
};

void deserialize_long(struct s_serialized *s_val, void *var)
{
	long *value = var;

	if(s_val->data)
		*value = *(long*)s_val->data;
};


void serialize_float(struct s_serialized *s_val, void *var)
{
	float *value = var;

	s_val->size = sizeof(float);
	s_val->data = malloc(sizeof(float));
	
	if(s_val->data)
		*(float*)s_val->data = *value;
};

void deserialize_float(struct s_serialized *s_val, void *var)
{
	float *value = var;

	if(s_val->data)
		*value = *(float*)s_val->data;
};


void serialize_double(struct s_serialized *s_val, void *var)
{
	double *value = var;

	s_val->size = sizeof(double);
	s_val->data = malloc(sizeof(double));
	
	if(s_val->data)
		*(double*)s_val->data = *value;
};

void deserialize_double(struct s_serialized *s_val, void *var)
{
	double *value = var;

	if(s_val->data)
		*value = *(double*)s_val->data;
};

