#ifndef _HASH_H_ 
#define _HASH_H_

#define HASH_TABLE_SIZE	65535

typedef unsigned int (*t_hash_fn)(void *);
typedef int (*t_hash_key_compare_fn)(void *, void *);
typedef void *(*t_hash_key_copy_fn)(void *);
typedef void (*t_hash_key_free_fn)(void *);

struct s_hash_entry
{
	char *name;
	void *data;
	struct s_hash_entry *next;
};

struct s_btree
{
	void *key;
	void *data;
	struct s_btree *right, *left;
};

struct s_hash
{
	struct s_btree *hash[HASH_TABLE_SIZE];
	t_hash_key_compare_fn key_cmp;
	t_hash_key_copy_fn key_cpy;
	t_hash_key_free_fn key_free;
	t_hash_fn hash_function;
};

typedef struct s_hash t_hash;

void *hash_find(t_hash *, void *);
void hash_add(t_hash *, void *, void *);
void hash_del(t_hash *, void *);
t_hash *hash_create(t_hash_key_compare_fn, t_hash_key_copy_fn, t_hash_key_free_fn, t_hash_fn);
t_hash *hash_create_str();

#endif
