#ifndef MYSQLW_H
#define MYSQLW_H
#include <stdio.h>
#include <stdlib.h>
#ifdef	WINDOWS
#include <my_global.h>
#endif
#include <mysql.h>
#include <mysqld_error.h>

//#include <dmalloc.h>

struct s_conn_params
{
	char *host;
	unsigned int port;
	char *socket;
};

struct s_mysql
{
	MYSQL connection;
};

struct s_mysql_result
{
	struct s_mysql *mysql;
	MYSQL_RES *result;
	long num_fields;
	long num_rows;
	long cursor;
	MYSQL_FIELD *fields;
	struct s_mysql_row *rows;
};

struct s_mysql_row
{
	struct s_mysql_result *result;
	MYSQL_ROW row;
	long *lengths;
};

typedef struct s_mysql t_mysql;
typedef struct s_mysql_result t_mysql_result;
typedef struct s_mysql_row t_mysql_row;
typedef struct s_conn_params t_conn_params;

int mysqlw_escape_string(char **string, char *str);
int mysqlw_escape_binstring(char **string, char *str, int length);
t_mysql *mysqlw_connect(char *host, char *username, char *password, char *db);
t_mysql *mysqlw_connect_params(t_conn_params *params, char *username, char *password, char *db);
void mysqlw_close(t_mysql *conn);
t_mysql_result *mysqlw_query(t_mysql *conn, char *fmt, ...);
t_mysql_row *mysqlw_fetch_row(t_mysql_result *result);
char *mysqlw_field_by_name(t_mysql_row *row, char *name);
long mysqlw_length_by_name(t_mysql_row *row, char *name);
long mysqlw_data_seek(t_mysql_result *result, long where);

#endif
