#include <stdlib.h>
#include <string.h>
#include <cgi/conn_pool.h>

t_conn_pool *conn_pool_create(long size)
{
	t_conn_pool *pool;
	
	pool = malloc(sizeof(t_conn_pool));
	bzero(pool, sizeof(t_conn_pool));
	
	pool->data = malloc(sizeof(t_mysql*) * size);
	if(pool->data)
		bzero(pool->data, sizeof(t_mysql*) * size);
	
	pool->size = size;
	pool->last = -1;

	return pool;
};

void conn_pool_free(t_conn_pool *pool)
{
	int i;
	
	pool->locked = 1;
	
	for(i = 0; i < (pool->last + 1); i ++)
	{
		mysqlw_close(pool->data[i]);
	}
	
	pool->size = 0;

	free(pool->data);
	free(pool);
};

int conn_push(t_conn_pool *pool, t_mysql *conn)
{
	while(pool->locked);

	pool->locked = 1;

	if(pool->last == (pool->size - 1))
	{
		pool->locked = 0;
		mysqlw_close(conn);
		return -1;
	}
	
	pool->data[++ pool->last] = conn;

	pool->locked = 0;
	
	return 0;
};

t_mysql *conn_pop(t_conn_pool *pool)
{
	t_mysql *conn;

	while(pool->locked);

	pool->locked = 1;
	
	if(pool->last == -1)
	{
		pool->locked = 0;
		return NULL;
	}
	
	conn = pool->data[pool->last --];
	pool->locked = 0;

	return conn;
};

