#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/mman.h>
//#include <dmalloc.h>
#include <cgi/hash.h>

unsigned int string_hash_function(char *key)
{
	unsigned int i = 0;
	
	i += (*key++);
	if(i << 8)
		i += *key;

	return i;
};

t_hash *hash_create_strkey()
{
	return hash_create( (t_hash_key_compare_fn)&strcmp, 
						(t_hash_key_copy_fn)&strdup, 
						(t_hash_key_free_fn)&free, 
						(t_hash_fn)&string_hash_function);
};

t_hash *hash_create(t_hash_key_compare_fn cmp, t_hash_key_copy_fn cpy, t_hash_key_free_fn kfree, t_hash_fn hash_fn)
{
	t_hash *hash;

	hash = malloc(sizeof(t_hash));
	bzero(hash, sizeof(t_hash));
	hash->hash_function = hash_fn;
	hash->key_cpy = cpy;
	hash->key_cmp = cmp;
	hash->key_free = kfree;

	return hash;
};

void *hash_find(t_hash *hash, void *key)
{
	struct s_btree *node;
	int match;

	node = hash->hash[hash->hash_function(key) % HASH_TABLE_SIZE];

	while(node)
	{
		match = hash->key_cmp(node->key, key);
		
		if(!match)
		{
			return node->data;
		}
		else if(match < 0)
		{
			node = node->right;
		}
		else if(match > 0)
		{
			node = node->left;
		};
	}

	return NULL;
};

void hash_add(t_hash *hash, void *key, void *data)
{
	struct s_btree *node;
	int match;
	unsigned int i;

	node = hash->hash[i = hash->hash_function(key) % HASH_TABLE_SIZE];

	while(node)
	{
		match = hash->key_cmp(node->key, key);
		
		if(!match)
		{
			node->data = data;
			return;
		}
		else if(match < 0)
		{
			if(node->right)
			{
				node = node->right;
			}
			else
			{
				node->right = malloc(sizeof(struct s_btree));
				node = node->right;
				break;
			}
		}
		else if(match > 0)
		{
			if(node->left)
			{
				node = node->left;
			}
			else
			{
				node->left = malloc(sizeof(struct s_btree));
				node = node->left;
				break;
			}
		}
	}

	if(!node)
		node = hash->hash[i] = malloc(sizeof(struct s_btree));;

	bzero(node, sizeof(struct s_btree));

	node->data = data;
	node->key = hash->key_cpy(key);
};

void hash_del(t_hash *hash, void *key)
{
	struct s_btree *node, *right, **prev;
	int match;
	unsigned int i;

	node = *(prev = &hash->hash[i = hash->hash_function(key) % HASH_TABLE_SIZE]);

	while(node)
	{
		match = hash->key_cmp(node->key, key);
		
		if(!match)
		{
			if(node->right)
			{
				*prev = node->right;
				right = node->right;
				while(right->left)
				{
					right = right->left;
				}
				right->left = node->left;
			}
			else
			{
				*prev = node->left;
			}
			hash->key_free(node->key);
			free(node);
			return;
		}
		else if(match < 0)
		{
			prev = &node->right;
			node = node->right;
		}
		else if(match > 0)
		{
			prev = &node->left;
			node = node->left;
		};
	}
};

void hash_free(t_hash *hash)
{
	unsigned long i;

	for(i = 0; i < HASH_TABLE_SIZE; i ++)
	{
		while(hash->hash[i])
		{
			hash_del(hash, hash->hash[i]->key);
		}
	}

	free(hash);
};

#ifdef TEST
#include <stdio.h>
#include <sys/time.h>

unsigned int string_hash_function(char *key)
{
	unsigned int i = 0;
	
	i += (*key++);
	if(i << 8)
		i += *key;

	return i;
};

int main()
{
	t_hash *hash;
	unsigned long i, j;
	char b;
	char a[] = "hello, world";
	char key[10];
	struct timespec ts1, ts2;

	hash = hash_create(&strcmp, &strdup, &free, &string_hash_function);
	key[9] = 0;

	srandom(time(NULL));

	fprintf(stderr, "Filling hash with 3000000 random values -->\n");

	for(i = 0; i < 3000000; i ++)
	{
		for(j = 0; j < 9; j ++)
		{
			do
			{
				b = random() % 255;
			} 
			while(!isalnum(b));

			key[j] = b;
		}

		hash_add(hash, key, a);
	}

	fprintf(stderr, "Starting search and output (3000000 iterations) -->\n");
	clock_gettime(CLOCK_PROF, &ts1);

	for(i = 0; i < 3000000; i ++)
		hash_find(hash, key);

	clock_gettime(CLOCK_PROF, &ts2);
	fprintf(stderr, "End search -->\n");
	
	fprintf(stderr, "Time spend in find procedure: %f sec.\n", (double)((double)(ts2.tv_sec-ts1.tv_sec)+(double)(ts2.tv_nsec-ts1.tv_nsec)/(double)1000000000));

	hash_free(hash);
}
#endif
