#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <cgi/mysqlw.h>
#include <cgi/nasprintf.h>

int mysqlw_escape_string(char **string, char *str)
{
	int len, real_len = 0;
	char *escaped;

	len = strlen(str);
	escaped = malloc(len * 2 + 1);

	if(escaped)
	{
		real_len = mysql_escape_string(escaped, str, len);
		escaped = realloc(escaped, real_len + 1);
		escaped[real_len] = '\0';
	}
	
	*string = escaped;
	return real_len;
}

void mysqlw_close(t_mysql *conn)
{
	mysql_close(&conn->connection);
	free(conn);
}

int mysqlw_escape_binstring(char **string, char *str, int length)
{
	int len, real_len = 0;
	char *escaped;

	len = length;
	escaped = malloc(len * 2 + 1);

	if(escaped)
	{
		real_len = mysql_escape_string(escaped, str, len);
		escaped = realloc(escaped, real_len);
	}
	
	*string = escaped;
	return real_len;
}

t_mysql *mysqlw_connect(char *host, char *username, char *password, char *db)
{
	MYSQL *conn = NULL;
	t_mysql *my_conn = malloc(sizeof(t_mysql));
	long connect_timeout = 60;

	if(!my_conn)
		return NULL;
	
	mysql_init(&my_conn->connection);

#if MYSQL_VERSION_ID >= 32200
	mysql_options(&my_conn->connection, MYSQL_OPT_CONNECT_TIMEOUT, (const char *)&connect_timeout);
	if(!mysql_real_connect(&my_conn->connection, host,
						   username, password, db, 0, NULL, 0))
	{
		goto BAIL_OUT;
	};
#else
	if(!mysql_connect(&my_conn->connection, host, username, password))
	{
		goto BAIL_OUT;
	};

	mysql_select_db(&my_conn->connection, db);
#endif

	return my_conn;

BAIL_OUT:
	if(conn)
		mysql_close(conn);
	if(my_conn)
		free(my_conn);
	return NULL;
}

t_mysql *mysqlw_connect_params(t_conn_params *params, char *username, char *password, char *db)
{
	MYSQL *conn = NULL;
	t_mysql *my_conn = malloc(sizeof(t_mysql));
	long connect_timeout = 60;

	if(!my_conn)
		return NULL;
	
	mysql_init(&my_conn->connection);

#if MYSQL_VERSION_ID >= 32200
	mysql_options(&my_conn->connection, MYSQL_OPT_CONNECT_TIMEOUT, (const char *)&connect_timeout);
	if(!mysql_real_connect(&my_conn->connection, params->host,
						   username, password, db, params->port, params->socket, 0))
	{
		goto BAIL_OUT;
	};
#else
	if(!mysql_connect(&my_conn->connection, params->host, username, password))
	{
		goto BAIL_OUT;
	};

	mysql_select_db(&my_conn->connection, db);
#endif

	return my_conn;

BAIL_OUT:
	if(conn)
		mysql_close(conn);
	if(my_conn)
		free(my_conn);
	return NULL;
}

t_mysql_result *mysqlw_query(t_mysql *conn, char *fmt, ...)
{
	MYSQL_RES *res = NULL;
	t_mysql_result *result = NULL;
	char *query = NULL;
	va_list v;
	
	va_start(v, fmt);
	if(nvasprintf(&query, fmt, v) < 1)
		return NULL;
	va_end(v);
	
	if(mysql_query(&conn->connection, query))
	{
		goto BAIL_OUT;
	}
	free(query);
	query = NULL;
	
	res = mysql_store_result(&conn->connection);
	
	if(!res)
		goto BAIL_OUT;

	result = malloc(sizeof(t_mysql_result));
	if(!result)
		goto BAIL_OUT;
	
	result->rows = NULL;
	result->result = res;
	
	result->mysql = conn;
	result->num_fields = mysql_num_fields(result->result);
	result->num_rows = mysql_num_rows(result->result);
	result->fields = mysql_fetch_fields(result->result);

	result->rows = calloc(result->num_rows, sizeof(t_mysql_row));

	if(!result->rows)
		goto BAIL_OUT;

	bzero(result->rows, result->num_rows * sizeof(t_mysql_row));
	result->cursor = 0;
	
	return result;

BAIL_OUT:
	if(query)
		free(query);

	if(result)
	{
		if(result->result)
			mysql_free_result(result->result);
		if(result->rows)
		{
			free(result->rows);
		}
	}
	return NULL;
}

t_mysql_row *mysqlw_fetch_row(t_mysql_result *result)
{
	MYSQL_ROW row;

	if((row = mysql_fetch_row(result->result)))
	{
		result->rows[result->cursor].result = result;
		result->rows[result->cursor].lengths = mysql_fetch_lengths(result->result);
		result->rows[result->cursor].row = row;
		return &result->rows[result->cursor ++];
	}

	return NULL;
}

char *mysqlw_field_by_name(t_mysql_row *row, char *name)
{
	int i;
	
	for(i = 0; i < row->result->num_fields; i ++)
	{
		if(name && row->result->fields[i].name)
		{
			if(!strcmp(name, row->result->fields[i].name))
			{
				return row->row[i];
			}
		}
	}
	
	return NULL;
}

long mysqlw_length_by_name(t_mysql_row *row, char *name)
{
	int i;
	
	for(i = 0; i < row->result->num_fields; i ++)
	{
		if(name && row->result->fields[i].name)
		{
			if(!strcmp(name, row->result->fields[i].name))
			{
				return (long)row->lengths[i];
			}
		}
	}
	
	return 0;
}

void mysqlw_free_result(t_mysql_result *result)
{
	free(result->rows);
	mysql_free_result(result->result);
	free(result);
}

long mysqlw_data_seek(t_mysql_result *result, long where)
{
	result->cursor = where;
	mysql_data_seek(result->result, (my_ulonglong)where);
	return where;
}
