#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
//#include <dmalloc.h>
#include <cgi/nasprintf.h>
#include <cgi/mysqlw.h>

inline void push_char(char **buf, char **buf_ptr, long *buf_len, long discr, const int chr);
inline void push_string(char **buf, char **buf_ptr, long *buf_len, long discr, const char *str);
inline int eat_char(char **string, int ch);
inline int eat_number(char **string);
inline int eat_one_of(char **string, char *syms);

inline void push_char(char **buf, char **buf_ptr, long *buf_len, long discr, const int chr)
{
	char *tmp;
	long offset = *buf_ptr - *buf;
	
	if((*buf_len - offset) < 1)
	{
		tmp = realloc(*buf, *buf_len + discr);
		if(!tmp)
			return;
		*buf = tmp;
		*buf_ptr = *buf + offset;
		*buf_len += discr;
	}
	
	**buf_ptr = (char)chr;
	*(++(*buf_ptr)) = '\0';
}

inline int eat_char(char **string, int ch)
{
	if(**string == (char)ch)
	{
		(*string) ++;
		return 1;
	}

	return 0;
};

inline int eat_number(char **string)
{
	int res = 0;
	char *num = "0123456789";

	while(strchr(num, **string))
	{
		res ++;
		(*string) ++;
	}
	return res;
};

inline int eat_one_of(char **string, char *syms)
{
	int res = 0;

	while(strchr(syms, **string))
	{
		res ++;
		(*string) ++;
	}
	return res;
};

inline void push_string(char **buf, char **buf_ptr, long *buf_len, long discr, const char *str)
{
	char *tmp;
	long offset = *buf_ptr - *buf;
	long length = strlen(str);
	
	while((*buf_len - offset) < length)
	{
		tmp = realloc(*buf, *buf_len + discr);
		if(!tmp)
			return;
		*buf = tmp;
		*buf_ptr = *buf + offset;
		*buf_len += discr;
	}
	
	strcat(*buf_ptr, str);
	*buf_ptr += length;
}

int nvasprintf(char **str, char *fmt, va_list v)
{
	char *fmtPos = fmt, *fmtStart;
	char *buffer = malloc(256);
	char *bufferPos = buffer;
	long bufferLen = 256, fmtLen;
	char fmtBuffer[32], *formattedBuffer = NULL;
	int fmtFlag = 0, i, j;
	
	int intarg;
	long longarg;
	long long longlongarg;
	char *strarg, *escaped_str;
	size_t size_targ;
	double doublearg;
	long double longdoublearg;
	
	if(!buffer)
		return -1;

	*buffer = '\0';
	
	while(*fmtPos)
	{
		if(eat_char(&fmtPos, '%'))
		{
			fmtFlag = 0;
			fmtStart = fmtPos - 1;

			while(eat_one_of(&fmtPos, "#0- +'.") || eat_number(&fmtPos));

			i = 0;
			if(eat_char(&fmtPos, 'l'))
			{
				fmtFlag = (eat_char(&fmtPos, 'l') ? 2 : 1);
			}
			else if(eat_char(&fmtPos, 'j'))
			{
				fmtFlag = 3;
			}
			else if(eat_char(&fmtPos, 't'))
			{
				fmtFlag = 4;
			}
			else if(eat_char(&fmtPos, 'L'))
			{
				fmtFlag = 5;
			}
			else if(eat_char(&fmtPos, 'q'))
			{
				fmtFlag = 6;
			}
			else if(eat_char(&fmtPos, 'b'))
			{
				fmtFlag = 7;
			}
			
			switch(*fmtPos)
			{
				case '%':
					if(!fmtFlag)
					{
						push_char(&buffer, &bufferPos, &bufferLen, 256, '%');
						fmtFlag = 0;
					}
					else
					{
						for(i = 0; i < (fmtPos - fmtStart); i ++)
						{
							push_char(&buffer, &bufferPos, &bufferLen, 256, *(fmtStart + i));
						}
					}
					break;
				case 'D':
				case 'O':
				case 'U':
					// long int
					fmtFlag = 1;
				case 'd':
				case 'i':
				case 'o':
				case 'u':
				case 'x':
				case 'X':
					// int, long int, long long
					fmtLen = fmtPos - fmtStart + 1;
					if(fmtLen > 31) // looks like overflow
						goto BAIL_OUT;
					
					memcpy(fmtBuffer, fmtStart, fmtLen);
					fmtBuffer[fmtLen] = '\0';
					
					switch(fmtFlag)
					{
						case 0:
							intarg = va_arg(v, int);
							if(asprintf(&formattedBuffer, fmtBuffer, intarg) < 0)
								goto BAIL_OUT;
							break;
						case 1:
							longarg = va_arg(v, long);
							if(asprintf(&formattedBuffer, fmtBuffer, longarg) < 0)
								goto BAIL_OUT;
							break;
						case 2:
							longlongarg = va_arg(v, long long);
							if(asprintf(&formattedBuffer, fmtBuffer, longlongarg) < 0)
								goto BAIL_OUT;
							break;
						case 3:
						case 4:
							size_targ = va_arg(v, size_t);
							if(asprintf(&formattedBuffer, fmtBuffer, size_targ) < 0)
								return -1;
							break;
						default:
							// Error!
							goto BAIL_OUT;
					}
					break;
				case 'e':
				case 'E':
				case 'f':
				case 'F':
				case 'g':
				case 'G':
				case 'a':
				case 'A':
					// double
					fmtLen = fmtPos - fmtStart + 1;
					if(fmtLen > 31) // looks like overflow
						goto BAIL_OUT;
					
					memcpy(fmtBuffer, fmtStart, fmtLen);
					fmtBuffer[fmtLen] = '\0';
					
					switch(fmtFlag)
					{
						case 0:
						case 1:
							doublearg = va_arg(v, double);
							if(asprintf(&formattedBuffer, fmtBuffer, doublearg) < 0)
								goto BAIL_OUT;
							break;
						case 5:
							longdoublearg = va_arg(v, long double);
							if(asprintf(&formattedBuffer, fmtBuffer, longdoublearg) < 0)
								goto BAIL_OUT;
							break;
						default:
							// Error!
							goto BAIL_OUT;
					}
					break;
				case 'c':
				case 'C':
					// char
					fmtLen = fmtPos - fmtStart + 1;
					if(fmtLen > 31) // looks like overflow
						goto BAIL_OUT;
					
					memcpy(fmtBuffer, fmtStart, fmtLen);
					fmtBuffer[fmtLen] = '\0';
					
					switch(fmtFlag)
					{
						case 0:
						case 1:
							intarg = va_arg(v, int);
							if(asprintf(&formattedBuffer, fmtBuffer, intarg) < 0)
								goto BAIL_OUT;
							break;
						default:
							// Error!
							goto BAIL_OUT;
					}
					break;
				case 's':
				case 'S':
					// string
					fmtLen = fmtPos - fmtStart + 1;
					if(fmtLen > 31) // looks like overflow
						goto BAIL_OUT;
					
					memcpy(fmtBuffer, fmtStart, fmtLen);
					fmtBuffer[fmtLen] = '\0';
					
					switch(fmtFlag)
					{
						case 0:
							strarg = va_arg(v, char*);
							if(asprintf(&formattedBuffer, fmtBuffer, strarg) < 0)
								goto BAIL_OUT;
							break;
						case 6:
							strarg = va_arg(v, char*);
							for(i = 0, j = 0; i < fmtLen + 1; i ++, j ++)
							{
								if(fmtBuffer[i] == 'q')
									j --;
								else
									fmtBuffer[j] = fmtBuffer[i];
							}
							mysqlw_escape_string(&escaped_str, strarg);
							if(asprintf(&formattedBuffer, fmtBuffer, escaped_str) < 0)
								goto BAIL_OUT;
							free(escaped_str);
							break;
						case 7:
							strarg = va_arg(v, char*);
							longarg = va_arg(v, long);
							for(i = 0, j = 0; i < fmtLen + 1; i ++, j ++)
							{
								if(fmtBuffer[i] == 'b')
									j --;
								else
									fmtBuffer[j] = fmtBuffer[i];
							}
							mysqlw_escape_binstring(&escaped_str, strarg, longarg);
							if(asprintf(&formattedBuffer, fmtBuffer, escaped_str) < 0)
								goto BAIL_OUT;
							free(escaped_str);
							break;
						default:
							// Error!
							goto BAIL_OUT;
					}
					break;
				case 'P':
					// pointer
					fmtLen = fmtPos - fmtStart + 1;
					if(fmtLen > 31) // looks like overflow
						goto BAIL_OUT;
					
					memcpy(fmtBuffer, fmtStart, fmtLen);
					fmtBuffer[fmtLen] = '\0';
					
					switch(fmtFlag)
					{
						case 0:
							strarg = va_arg(v, char*);
							if(asprintf(&formattedBuffer, fmtBuffer, strarg) < 0)
								goto BAIL_OUT;
							break;
						default:
							// Error!
							goto BAIL_OUT;
					}
					break;
			}
			
			fmtPos ++;
			push_string(&buffer, &bufferPos, &bufferLen, 256, formattedBuffer);
			free(formattedBuffer);
		}
		else
		{
			push_char(&buffer, &bufferPos, &bufferLen, 256, *fmtPos);
			fmtPos ++;
		}
	}

	*str = buffer;
	return strlen(buffer);
	
BAIL_OUT:
	if(buffer)
		free(buffer);
	return -1;
}

int nasprintf(char **str, char *fmt, ...)
{
	int result;
	va_list v;
	va_start(v, fmt);
	
	result = nvasprintf(str, fmt, v);
	
	va_end(v);
	return result;
}

#ifdef TEST

int main()
{
	char *str;
	char bin[100];
	int i;

	srandom(time(NULL));	
	for(i = 0; i < 100; i ++)
	{
		bin[i] = random()%256;
	}

	nasprintf(&str, "SELECT * FROM test_tbl WHERE test_id=%d AND TEST_NAME='%bs'", 15, bin, (long)100);

	printf("%s\n", str);

	free(str);
	
	return 0;
}

#endif

