#ifndef CGI_HTML_TREE_H
#define CGI_HTML_TREE_H

#include <stdio.h>

//#include <dmalloc.h>

struct ATTR_LIST
{
	char *name;
	char *value;
	struct ATTR_LIST	*next;
};

struct TREE_NODE
{
	char *text;
	char *tag_name;

	int	is_text_node;
	int is_closing;
	int is_closed;
	int is_visible;

	struct ATTR_LIST *attributes;

	struct TREE_NODE *next_sibling;
	struct TREE_NODE *prev_sibling;

	struct TREE_NODE *children, *parent;
	struct TREE_NODE *closing_tag;
	int is_changed;
};

typedef struct TREE_NODE TAG;
typedef struct ATTR_LIST ATTR;

inline TAG *createElement();
inline TAG *createTextNode();
TAG *appendChild(TAG*, TAG*);
TAG *appendSibling(TAG*, TAG*);
void removeSibling(TAG*, TAG*);
void removeChild(TAG*, TAG*);
void deleteNode(TAG*);
void deleteTree(TAG*);
inline TAG* findBack(TAG*, char*);
inline TAG* findBackPlain(TAG*, char*);
TAG *findPrev(TAG *);
TAG* copyTree(TAG *a);
TAG* copyBranch(TAG *a);
TAG* copyNode(TAG *a);
void dumpTree(TAG *, FILE *);
TAG* findNode(TAG* a, char* name);
TAG* findNext(TAG* a);
TAG* findNextPlain(TAG* a);
TAG* insertAfter(TAG*, TAG*);
TAG* insertBefore(TAG*, TAG*);
TAG* extractFrom(TAG *);
TAG* replaceNode(TAG *, TAG *);
TAG* recurseNodes(TAG *);
TAG* getElementById(TAG *, char *);

// Functions for working with attributes

inline ATTR *addAttribute(TAG*);
inline ATTR *createAttribute();
inline void deleteAttribute(ATTR *);

inline char	*getAttribute(TAG*, char*);
inline void setAttribute(TAG*, char*, char*);
inline void removeAttribute(TAG*, char*);

// helpers

inline char *copy_unquoted(char *);

#endif
