#ifndef TEMPLATE_H
#define TEMPLATE_H

#include <stdio.h>
#include <cgi/html_tree.h>
#include <cgi/html_utils.h>

#ifndef SECTION_TAG
#	define SECTION_TAG	"SECTION"
#endif

#ifndef DIR_SEPARATOR
#	define	DIR_SEPARATOR	'/'
#endif

struct s_section
{
	char	*name;
	TAG		*document;
	TAG		*__safe_copy;
	char	*__file;
	struct s_section *template;
	struct s_section *sections;
	struct s_section *next;
	struct s_replacement *replacements;
};

struct s_replacement
{
	char *name;
#define	SRT_REPLACEMENT	1
#define SRT_OPTION		2
	int	 type;
	union
	{
		char *replacement;
		long option;
	} value;
	struct s_replacement *next;
};

typedef struct s_section t_template;
typedef struct s_section t_tpl_section;
typedef struct s_replacement t_replacement;

typedef void (*t_command_processor)(t_tpl_section *section, TAG* node, char **text, 
												char** tagstart, char **tagend, char *param);

t_template *create_t_template(char *filename);
t_tpl_section *get_tpl_section(t_template *, char *name);
void set_replace_section(t_tpl_section *, char *name, char *replacement);
void set_replace(t_template *, char *section_name, char *name, char *replacement);
void output_tpl_section(t_tpl_section *);

// Here are real-real-real template functions
t_template *template_create(char *filename);

void template_set(t_tpl_section *section, char *name, char *fmt, ...);
void template_opt(t_tpl_section *section, char *name, long selection);
void template_out(t_template *tpl, FILE *out);
void template_section_out(t_tpl_section *tpl);
t_tpl_section *template_find_section(t_template *tpl, char *name);
void template_insert(t_tpl_section *dest, char *where, t_tpl_section *src);
void template_free(t_tpl_section *section);


/*
 * Template command processors handlers
 */

void register_template_command_processor(char *cmd, t_command_processor processor);

void unregister_template_command_processor(char *cmd);

void free_template_command_processors(void);


#endif
