#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <cgi/html_tree.h>

TAG *createElement()
{
	TAG *element;
	element = (TAG*)malloc(sizeof(TAG));
	bzero(element, sizeof(TAG));
	element->is_visible = 1;
	return element;
};

TAG *createTextNode()
{
	TAG *node;
	node = (TAG*)malloc(sizeof(TAG));
	bzero(node, sizeof(TAG));
	node->is_text_node = 1;
	node->is_visible = 1;
	return node;
};

TAG *appendChild(TAG* a, TAG* b)
{
	register TAG *child;

	if(!a)
		return b;
	if(!b)
		return NULL;

	if(b->parent)
		removeChild(b->parent, b);

	child = a->children;

	if(child)
	{
		appendSibling(child, b);
	}
	else
	{
		child = a->children = b;

		while(child)
		{
			child->parent = a;
			child = child->next_sibling;
		}
	}

	return b;
};

TAG *appendSibling(TAG* a, TAG* b)
{
	register TAG *child;

	if(!a)
		return b;
	if(!b)
		return NULL;

	while(a->next_sibling)
		a = a->next_sibling;

	b->next_sibling = a->next_sibling;
	a->next_sibling = b;
	b->prev_sibling = a;

	child = a;

	while(child)
	{
		child->parent = a->parent;
		child = child->next_sibling;
	}
	
	if(b->next_sibling)
		b->next_sibling->prev_sibling = b;

	return b;
};

void removeSibling(TAG* a, TAG* b)
{
	TAG *first, *current;//, *last;
	
	if(!a || !b)
		return;

	first = a;

	while(first->prev_sibling)
		first = first->prev_sibling;

	current = first;

	if(b == first)
	{
		first = first->next_sibling;

		if(b->parent)
			b->parent->children = first;
	}

	while(current)
	{
		if(current == b)
		{
			if(b->prev_sibling)
				b->prev_sibling->next_sibling = b->next_sibling;

			if(b->next_sibling)
				b->next_sibling->prev_sibling = b->prev_sibling;

			b->prev_sibling = b->next_sibling = NULL;

			b->parent = NULL;

			return;
		}

		current = current->next_sibling;
	}

};

TAG* copyNode(TAG *a)
{
	TAG *newtag;
	register ATTR *attr, *newattr;

	if(!a)
		return NULL;

	newtag = (TAG*)malloc(sizeof(TAG));
	bzero(newtag, sizeof(TAG));
	
	newtag->is_text_node = a->is_text_node;
	newtag->is_closing = a->is_closing;
	newtag->is_closed = a->is_closed;
	newtag->is_visible = a->is_visible;
	newtag->is_changed = a->is_changed;

	if(a->tag_name)
		newtag->tag_name = strdup(a->tag_name);
	if(a->text)
		newtag->text = strdup(a->text);
	
	attr = a->attributes;

	while(attr)
	{
		newattr = addAttribute(newtag);
		if(attr->name)
			newattr->name = strdup(attr->name);
		if(attr->value)
			newattr->value = strdup(attr->value);
		attr = attr->next;
	}

	if(a->closing_tag)
		newtag->closing_tag = copyNode(a->closing_tag);

	return newtag;
}

TAG* extractFrom(TAG *a)
{
	TAG *child;
	TAG *current;

	if(!a)
		return NULL;

	current = child = a->children;

	if(!current)
		return NULL;

	while(current->next_sibling)
	{
		current->parent = NULL;
		current = current->next_sibling;
	}

	current->parent = NULL;

	a->children = NULL;
	
	return child;
}

TAG* replaceNode(TAG *a, TAG *b)
{
	TAG *tmp = NULL;

	if(a->prev_sibling)
		tmp = a->prev_sibling->next_sibling;
	if(b->prev_sibling)
		if(a->prev_sibling)
			a->prev_sibling->next_sibling = b->prev_sibling->next_sibling;
	if(a->prev_sibling)
		if(b->prev_sibling)
			b->prev_sibling->next_sibling = tmp;

	if(a->next_sibling)
		tmp = a->next_sibling->prev_sibling;
	if(b->next_sibling)
		if(a->next_sibling)
			a->next_sibling->prev_sibling = b->next_sibling->prev_sibling;
	if(a->next_sibling)
		if(b->next_sibling)
			b->next_sibling->prev_sibling = tmp;
	
	tmp = a->next_sibling;
	a->next_sibling = b->next_sibling;
	b->next_sibling = tmp;

	tmp = a->prev_sibling;
	a->prev_sibling = b->prev_sibling;
	b->prev_sibling = tmp;

	return b;
}

TAG* copyTree(TAG *a)
{
	TAG *newtag;

	if(!a)
		return NULL;

	newtag = copyNode(a);

	appendChild(newtag, copyTree(a->children));

	while(a->next_sibling)
	{
		appendSibling(newtag, copyBranch(a->next_sibling));
		a = a->next_sibling;
	}

	return newtag;
}

TAG* copyBranch(TAG *a)
{
	TAG *newtag;
	//ATTR *attr, *newattr;

	if(!a)
		return NULL;

	newtag = copyNode(a);

	appendChild(newtag, copyTree(a->children));
	return newtag;
}

TAG* insertAfter(TAG* a, TAG* b)
{
	TAG *first, *last;
	TAG *next;

	first = b;
	last = b;

	if(!a)
		return b;
	
	if(!b)
		return NULL;

	while(last->next_sibling)
	{
		last->parent = a->parent;
		last = last->next_sibling;
	}

	last->parent = a->parent;

	next = a->next_sibling;
	a->next_sibling = first;
	
	first->prev_sibling = a;
	last->next_sibling = next;

	if(next)
		next->prev_sibling = last;

	return b;
}

TAG* insertBefore(TAG* a, TAG* b)
{
	TAG *first, *last;
	TAG *next;

	first = b;
	last = b;

	if(!a)
		return b;
	
	if(!b)
		return NULL;

	while(last->next_sibling)
	{
		last->parent = a->parent;
		last = last->next_sibling;
	}

	last->parent = a->parent;

	next = a->prev_sibling;
	a->prev_sibling = last;
	
	last->next_sibling = a;
	first->prev_sibling = next;

	if(next)
		next->next_sibling = first;

	if(a->parent)
		if(a->parent->children == a)
			a->parent->children = first;

	return b;
}

TAG* findNode(TAG* a, char* name)
{
	TAG *found;

	if(!a)
		return NULL;

	if(a->tag_name)
		if(!strcasecmp(a->tag_name, name))
		{
			return a;
		}

	if((found = findNode(a->children, name)))
		return found;
	
	if((found = findNode(a->next_sibling, name)))
		return found;
	
	return NULL;
}

TAG* findNext(TAG* a)
{
	TAG *found;
	
	if(!a)
		return NULL;

	if((found = findNode(a->children, a->tag_name)))
		return found;
	
	if((found = findNode(a->next_sibling, a->tag_name)))
		return found;

	if(a->parent)
		if((found = findNode(a->parent->next_sibling, a->tag_name)))
			return found;
	
	return NULL;
}

TAG* findNextPlain(TAG* a)
{
	TAG *found;
	
	if(!a)
		return NULL;

	if((found = findNode(a->next_sibling, a->tag_name)))
		return found;

	if(a->parent)
		if((found = findNode(a->parent->next_sibling, a->tag_name)))
			return found;

	return NULL;
}

TAG* findBackPlain(TAG* a, char* name)
{
	TAG *first;
	
	if(!a || !name)
		return NULL;

	first = a;
	while(first)
	{
		if(first->tag_name)
			if(!strcasecmp(first->tag_name, name))
			{
				return first;
			}

		first = first->prev_sibling;
	}

	return findBack(a->parent, name);
};

TAG* findBack(TAG* a, char* name)
{
	TAG *first, *children;
	
	if(!a || !name)
		return NULL;

	children = a->children;
	
	while(children)
	{
		children = children->next_sibling;
	}

	if((first = findBack(children, name)))
	{
		return first;
	}

	if((first = findBack(a->prev_sibling, name)))
	{
		return first;
	}

	return findBack(a->parent, name);
};

TAG* recurseNodes(TAG *a)
{
	TAG *found;

	if(!a)
		return NULL;

	if(a->children)
		return a->children;

	if(a->next_sibling)
		return a->next_sibling;

	found = a;

	while(found->parent)
	{
		if(found->parent->next_sibling)
			return found->parent->next_sibling;
		found = found->parent;
	}

	return NULL;
};

void compareTrees(TAG *a, TAG *b)
{
	ATTR *aattr, *battr;
	//, *next;

	if(a->is_text_node != b->is_text_node)
	{
		b->is_text_node = a->is_text_node;
	};
	if(a->is_closing != b->is_closing)
	{
		b->is_closing = a->is_closing;
	};
	if(a->is_closed != b->is_closed)
	{
		b->is_closed = a->is_closed;
	};
	if(a->is_visible != b->is_visible)
	{
		b->is_visible = a->is_visible;
	};
	if(a->is_changed != b->is_changed)
	{
		b->is_changed = a->is_changed;
	};

	if(a->text)
	{
		if(b->text)
		{
			if(strcmp(a->text, b->text))
			{
				free(b->text);
				b->text = strdup(a->text);
			}
		}
		else
			b->text = strdup(a->text);
	}
	else
	{
		if(b->text)
		{
			free(b->text);
			b->text = NULL;
		}
	};

	if(!a->is_text_node)
	{
		if(a->tag_name)
		{
			if(b->tag_name)
			{
				if(strcmp(a->tag_name, b->tag_name))
				{
					free(b->tag_name);
					b->tag_name = strdup(a->tag_name);
				}
			}
			else
				b->tag_name = strdup(a->tag_name);
		}
		else
		{
			if(b->tag_name)
			{
				free(b->tag_name);
				b->tag_name = NULL;
			}
		}
		
		aattr = a->attributes;
		battr = b->attributes;
		
		while(aattr)
		{
			if(!battr)
			{
				battr = addAttribute(b);
			}
			
			if(aattr->name)
			{
				if(battr->name)
				{
					if(strcmp(aattr->name, battr->name))
					{
						free(battr->name);
						battr->name = strdup(aattr->name);
					}
				}
				else
				{
					battr->name = strdup(aattr->name);
				}
			}
			else
			{
				if(battr->name)
				{
					free(battr->name);
					battr->name = NULL;
				}
			}

			if(aattr->value)
			{
				if(battr->value)
				{
					if(strcmp(aattr->value, battr->value))
					{
						free(battr->value);
						battr->value = strdup(aattr->value);
					}
				}
				else
				{
					battr->value = strdup(aattr->value);
				}
			}
			else
			{
				if(battr->value)
				{
					free(battr->value);
					battr->value = NULL;
				}
			}

			aattr = aattr->next;
			battr = battr->next;
		}
		
		if(a->closing_tag)
		{
			if(!b->closing_tag)
			{
				b->closing_tag = copyNode(a->closing_tag);
			}
			else
			{
				compareTrees(a->closing_tag, b->closing_tag);
			}
		}
		else if(b->closing_tag)
		{
			deleteTree(b->closing_tag);
			b->closing_tag = NULL;
		}

		if(a->children)
		{
			if(!b->children)
			{
				b->children = copyNode(a->children);
			}
			else
			{
				compareTrees(a->children, b->children);
			}
		}
		else if(b->children)
		{
			deleteTree(b->children);
			b->children = NULL;
		}

	}

	if(a->next_sibling)
	{
		if(!b->next_sibling)
		{
			b->next_sibling = copyNode(a->next_sibling);
		}
		else
		{
			compareTrees(a->next_sibling, b->next_sibling);
		}
	}
	else if(b->next_sibling)
	{
		deleteTree(b->next_sibling);
		b->next_sibling = NULL;
	}

}

TAG* findPrev(TAG* a)
{
	TAG *found;
	
	if(!a)
		return NULL;

	if((found = findBack(a->prev_sibling, a->tag_name)))
		return found;
	
	if((found = findBack(a->parent, a->tag_name)))
		return found;

	return NULL;
}

void removeChild(TAG* a, TAG* b)
{
	TAG *child;

	if(!a || !b)
		return;

	child = a->children;

	if(child)
	{
	
		removeSibling(child, b);

	};

};

inline void deleteNode(TAG* a)
{
	TAG *child;
	ATTR *attr, *next;
	
	if(!a)
		return;

	if(a->parent)
		removeChild(a->parent, a);

	if(a->text)
		free(a->text);

	attr = a->attributes;

	while(attr)
	{
		next = attr->next;
		deleteAttribute(attr);
		attr = next;
	}

	if(a->tag_name)
		free(a->tag_name);

	child = a->children;

	if(a->closing_tag)
		deleteNode(a->closing_tag);

/*	while(child)
	{
		deleteNode(child);
		child = child->next_sibling;
	}
*/
	free(a);
};

void deleteTree(TAG* a)
{
	TAG *child;
	ATTR *attr, *next;
	
	if(!a)
		return;

	if(a->next_sibling)
		deleteTree(a->next_sibling);

	child = a->children;

	if(child)
	{
		deleteTree(child);
	}

	if(a->parent)
	{
		a->parent->children = NULL;
	}

	if(a->closing_tag)
		deleteNode(a->closing_tag);

	if(a->text)
		free(a->text);

	attr = a->attributes;

	while(attr)
	{
		next = attr->next;
		deleteAttribute(attr);
		attr = next;
	}

	if(a->tag_name)
		free(a->tag_name);

	free(a);
};

char findQuote(char *str)
{
	while(*str)
	{
		if(*str == '"')
			return '\'';
		str ++;
	}

	return '"';
}

char *constructTag(TAG *tag)
{
	ATTR *attr;
	attr = tag->attributes;
	char *str, *tmp;
	char quote[] = "\"";
	long length;

	if(!tag->tag_name || tag->is_text_node)
		return tag->text;

	str = strdup(tag->tag_name);
	length = strlen(str);

	if(!tag->is_closing || tag->is_closed)
		while(attr)
		{
			if(attr->value)
			{
				if(*attr->value != '\0')
				{
					length += strlen(attr->name) + strlen(attr->value) + 4;
					tmp = malloc(length + 1); // =""\0
					strcpy(tmp, str);
					strcat(tmp, " ");
					strcat(tmp, attr->name);
					quote[0] = findQuote(attr->value);
					strcat(tmp, "=");
					strcat(tmp, quote);
					strcat(tmp, attr->value);
					strcat(tmp, quote);
				}
				else
				{
					length += strlen(attr->name) + strlen(attr->value) + 1;
					tmp = malloc(length + 1);
					strcpy(tmp, str);
					strcat(tmp, " ");
					strcat(tmp, attr->name);
				}
			}
			else
			{
				length += strlen(attr->name) + strlen(attr->value) + 1;
				tmp = malloc(length + 1); // =""\0
				strcpy(tmp, str);
				strcat(tmp, " ");
				strcat(tmp, attr->name);
			}
			
			free(str);
			str = tmp;
			
			attr = attr->next;
		}
	
	if(tag->is_closed && tag->is_closing)
	{
		tmp = (char*)malloc(strlen(str) + 4);
		strcpy(tmp, "<");
		strcat(tmp, str);
		strcat(tmp, "/>");
	}
	else if(tag->is_closing)
	{
		tmp = (char*)malloc(strlen(str) + 4);
		strcpy(tmp, "</");
		strcat(tmp, str);
		strcat(tmp, ">");
	}
	else
	{
		tmp = (char*)malloc(strlen(str) + 3);
		strcpy(tmp, "<");
		strcat(tmp, str);
		strcat(tmp, ">");
	}

	free(str);
	str = tmp;
	
	return str;
}

void generateText(TAG *root)
{
	char *start = NULL, *end = NULL, *newtag, *tag;
	long length, i, stlen = 0, endlen = 0;

	if(root->text)
	{
		length = strlen(root->text);
		for(i = 0; i < length; i ++)
			if(root->text[i] == '<')
			{
				root->text[i] = '\0';
				start = root->text;
				stlen = i;
				break;
			}
		for(i = length - 1; i >= 0; i --)
			if(root->text[i] == '>')
			{
				end = root->text + i + 1;
				endlen = length - i - 1;
				break;
			}
		tag = constructTag(root);
		newtag = (char*)malloc(stlen + endlen + strlen(tag) + 1);
		strcpy(newtag, start);
		strcat(newtag, tag);
		strcat(newtag, end);
		free(root->text);
		root->text = newtag;
		free(tag);
//		free(end);
	}
	else
	{
		root->text = constructTag(root);
	}

	root->is_changed = 0;
}

void dumpTree(TAG *root, FILE *out)
{
	TAG *node = root;

	if(!root)
		return;

	while(node)
	{

		if(node->is_visible)
		{
			if((!node->is_text_node) && node->is_changed)
				generateText(node);

			if(node->text)
				fputs(node->text, out);
	
			if(node->children)
				dumpTree(node->children, out);
		
			if(node->is_closed && node->closing_tag)
				dumpTree(node->closing_tag, out);
		}

		node = node->next_sibling;
	}
//	if(root->next_sibling)
//		dumpTree(root->next_sibling);
}

ATTR *createAttribute()
{
	ATTR *attr;
	attr = (ATTR*)malloc(sizeof(ATTR));
	bzero(attr, sizeof(ATTR));
	return attr;
};

void deleteAttribute(ATTR *a)
{
	if(a->name)
		free(a->name);
	if(a->value)
		free(a->value);
	free(a);
};

TAG* getElementById(TAG *node, char *id)
{
	char *element_id;
	TAG *found;

	found = node;

	do
	{
		element_id = getAttribute(found, "id");
		if(element_id)
		{
			if(!strcasecmp(element_id, id))
			{
				return found;
			}
		}
	} while((found = recurseNodes(found)));

	return NULL;
};

inline char *getAttribute(TAG* a, char* name)
{
	ATTR *attr;
	attr = a->attributes;

	while(attr)
	{
		if(attr->name)
			if(!strcasecmp(attr->name, name))
			{
				return attr->value;
			}
		attr = attr->next;
	}

	return NULL;
}

void setAttribute(TAG* a, char* name, char* value)
{
	ATTR *attr;
	attr = a->attributes;

	if(!name)
		return;

	a->is_changed = 1;

	while(attr)
	{
		if(attr->name)
			if(!strcasecmp(attr->name, name))
			{
				break;
			}
		attr = attr->next;
	}

	if(!attr)
	{
		attr = addAttribute(a);
		attr->name = strdup(name);
	}

	if(attr->value)
		free(attr->value);

	if(value)
		attr->value = strdup(value);
	else
		attr->value = strdup("");
}

void removeAttribute(TAG* a, char* name)
{
	ATTR *attr, *todel;
	attr = a->attributes;

	a->is_changed = 1;

	if(attr->name)
		if(!strcasecmp(attr->name, name))
		{
			a->attributes = attr->next;
			deleteAttribute(attr);
			return;
		}

	while(attr->next)
	{
		if(attr->next->name)
			if(!strcasecmp(attr->next->name, name))
			{
				todel = attr->next;
				attr->next = todel->next;
				deleteAttribute(todel);
				return;
			}
		attr = attr->next;
	}
}

ATTR *addAttribute(TAG* a)
{
	ATTR *attr, *current;

	attr = createAttribute();
	current = a->attributes;
	
	if(!current)
	{
		a->attributes = attr;
	}
	else
	{
		while(current->next)
		{
			current = current->next;
		}
		current->next = attr;
	}
	return attr;
};

char *copy_unquoted(char *string)
{
	char *unquoted;
	long len;

	if(!string)
		return NULL;
	
	len = strlen(string);
	if(len > 2)
	{
		if(*string == '"' || *string == '\'')
		{
			if(string[len - 1] == *string)
			{
				unquoted = (char*)malloc(len - 1);
				strncpy(unquoted, string + 1, len - 2);
				unquoted[len - 2] = '\0';
				return unquoted;
			}
		}
	}

	unquoted = (char*)malloc(len + 1);
	strcpy(unquoted, string);
	unquoted[len] = '\0';
	return unquoted;
};
