#include <stdlib.h>
#include <string.h>
#include <cgi/html_utils.h>

char *strip_tags(char *where)
{
	char *str = where, *result, *tmp;
	register int tag = 0;

	result = tmp = malloc(strlen(where) + 1);

	while(*str)
	{
		if((*str == '<') && !tag)
			tag ++;
		
		if(!tag)
			*(tmp++) = *str;
		
		if((*str == '>') && tag)
			tag --;

		str ++;
	}
	
	*(tmp) = '\0';
	
	return result;
};

char *replace(char *where, char *what, char *to)
{
	char *str = where, *start, *tmp;
	long count = 0, whatlen, tolen;
	long match = 0;

	if(!what || !to)
		return NULL;

	whatlen = strlen(what);
	tolen = strlen(to);

	while(*str)
	{
		if(*str == what[match])
			match ++;

		if(match == whatlen)
		{
			match = 0;
			count ++;
		}
	
		str ++;
	}

	if(!count)
		return strdup(where);

	tmp = malloc(strlen(where) - count * whatlen + count * tolen + 1);
	start = str = where;
	*tmp = '\0';

	while((str = strstr(str, what)))
	{
		strncat(tmp, start, str - start);
		strcat(tmp, to);
		str += whatlen;
		start = str;
	}

	strcat(tmp, start);

	return tmp;
};

char *replace_multi(char *where, char *what_to_list[][2], long count)
{
	char *str = where, *tmp, *result;
	register long found = 0;
	register long i = 0, length = 0;
	long *fromlengths, *tolengths, *match;

	tolengths = calloc(count*3, sizeof(long));
	fromlengths = tolengths + count;
	match = fromlengths + count;

	bzero(match, sizeof(long) * count);

	for(i = 0; i < count; i ++)
	{
		tolengths[i] = strlen(what_to_list[i][1]);
		fromlengths[i] = strlen(what_to_list[i][0]);
	}

	while(*str)
	{
		length ++;

		for(i = 0; i < count; i ++)
		{
			if(*str == what_to_list[i][0][match[i]])
				match[i] ++;
			
			if(match[i] == fromlengths[i])
			{
				length += tolengths[i] - fromlengths[i];
				bzero(match, sizeof(long) * count);
				break;
			}
		}

		str ++;
	}

	result = tmp = malloc(length + 1);
	str = where;
	bzero(match, sizeof(long) * count);

	while(*str)
	{
		found ^= found;

		for(i = 0; i < count; i ++)
		{
			if(*str == what_to_list[i][0][match[i]])
				match[i] ++;

			if(match[i] == fromlengths[i])
			{
				bzero(match, sizeof(long) * count);

				tmp -= fromlengths[i]-1;

				while(found < tolengths[i])
				{
					*(tmp++) = what_to_list[i][1][found];
					found ++;
				}

				break;
			}

		}

		if(!found)
		{
			*(tmp++) = *str;
		}

		str ++;
	}

	result[length] = 0;

	free(tolengths);

	return result;
};

char *html_special_chars(char *where)
{
	char *str = where, *result, *tmp;
	register long i;
	long length = 0;

// Init recode table elements
	char html_chars[] = "&\"'<>";
	char *html_recode[] = {"&amp;", "&quot;", "&apos;", "&lt;", "&gt;"};
	long tolengths[sizeof(html_recode) / sizeof(*html_recode)] = {5, 6, 4, 4};
// End of.

	register long count = (sizeof(html_recode) / sizeof(*html_recode));
	register long found = 0;

	while(*str)
	{
		length ++;

		for(i ^= i; i < count; i ++)
		{
			if(html_chars[i] == *str)
			{
				length += tolengths[i] - 1;
				break;
			}
		}

		str ++;
	}

	result = tmp = malloc(length + 1);
	str = where;

	while(*str)
	{
		found = 0;

		for(i ^= i; i < count; i ++)
		{
			if(html_chars[i] == *str)
			{
				while(found < tolengths[i])
				{
					*(tmp++) = *(html_recode[i] + found);
					found ++;
				}
				
				break;
			}
	
		}

		if(!found)
			*(tmp++) = *str;

		str ++;
	}

	result[length] = '\0';

	return result;
};

