#include <stdio.h>
#include <stdlib.h>
#include <cgi/cgi.h>
#include <cgi/template.h>
#include <cgi/mysqlw.h>

#define isset(var)	(var != NULL)
#define scalar(var) ((var) ? !((var)->is_array) : 0)

char *__SELF__;

struct s_page
{
	int is_first;
	int is_last;
	int is_active;
	int is_ellipse;
	int no;
};

void add_message(char *name, char *email, char *text)
{
	t_mysql *mysql;
	t_conn_params params = {"localhost", 0, "/tmp/mysql.sock"};

	mysql = mysqlw_connect_params(&params, "root", "", "test");
	mysqlw_query(mysql, "INSERT INTO gb_entries(id, name, email, entry_text, entry_date) "
				 "VALUES(NULL, '%qs', '%qs', '%qs', NOW())", name, email, text);
	mysqlw_close(mysql);
};

void output_pager(t_template *tpl, int page, int onpage, long records)
{
#define	RANGE	2
#define SIZE	(RANGE*4+5)
	struct s_page pages[SIZE];
	int i, j;
	long overall;
	t_tpl_section *pager;

	overall = (records / onpage) + (records % onpage ? 1 : 0);

	if((onpage - overall) > 0)
	{
		return;
	}

	for(i = 0, j = 0; i < overall; i ++)
	{
		if((i>RANGE) && ((overall-1-i)>RANGE) && (abs(i-page)>RANGE) &&
			!((page<(RANGE*2+2)) && (i<(RANGE*3+3))) && 
			!(((overall-1-page)<(RANGE*2+2)) && ((overall-1-i)<(RANGE*3+3))))
			continue;

		bzero(&pages[j], sizeof(pages[j]));

		if(j > 0)
		{
			if((pages[j-1].no != (i - 1)) && !pages[j-1].is_ellipse)
			{
				pages[j].is_ellipse = 1;
				j ++;
				bzero(&pages[j], sizeof(pages[j]));
			}
		}

		pages[j].is_first = (i == 0);
		pages[j].is_last = (i == (overall - 1));
		pages[j].is_active = (i == page);
		pages[j].no = i;
		j ++;
	}
	
	template_set(tpl, "script", "%s", __SELF__);

	template_set(tpl, "nextpage", "%d", page+1);
	template_set(tpl, "prevpage", "%d", page-1);

	template_set(tpl, "onpage", "%d", onpage);

	template_opt(tpl, "prevvisible", page > 0);
	template_opt(tpl, "nextvisible", page < (overall - 1));

	pager = template_find_section(tpl, "page");
	
	for(i = 0; i < SIZE; i ++)
	{
		template_set(pager, "script", "%s", __SELF__);
		template_set(pager, "onpage", "%d", onpage);
		template_set(pager, "pageno", "%d", pages[i].no);
		template_set(pager, "pagenum", "%d", pages[i].no + 1);
		template_opt(pager, "active", pages[i].is_active);
		template_opt(pager, "ellipse", pages[i].is_ellipse);
		template_section_out(pager);

		if(pages[i].is_last)
			break;
	}
	
	template_section_out(tpl);
};

t_template *output_entries(int page, int onpage)
{
	t_template *tpl = NULL;
	t_tpl_section *section;
	t_mysql *mysql = NULL;
	t_mysql_result *result = NULL, *res_overall;
	t_mysql_row *row;
	long overall;
	char *name, *email, *text, *date;
	struct timespec ts[2];
	t_conn_params params = {NULL, 0, "/tmp/mysql.sock"};

	if(!(tpl = template_create("templates/guestbook.html")))
		goto BAIL_OUT;

	clock_gettime(CLOCK_PROF, &ts[0]);
	
	mysql = mysqlw_connect_params(&params, "root", "", "test");

	clock_gettime(CLOCK_PROF, &ts[1]);

	if(!mysql)
		goto BAIL_OUT;

	result = mysqlw_query(mysql, "SELECT SQL_CALC_FOUND_ROWS * FROM gb_entries "
								 "ORDER BY entry_date DESC LIMIT %d, %d", page * onpage, onpage);
	if(!result)
		goto BAIL_OUT;

	if(!(res_overall = mysqlw_query(mysql, "SELECT FOUND_ROWS() as overall")))
		goto BAIL_OUT;

	if(!(row = mysqlw_fetch_row(res_overall)))
		goto BAIL_OUT;

	overall = atol(mysqlw_field_by_name(row, "overall"));

	if(!(section = template_find_section(tpl, "post")))
		goto BAIL_OUT;
	
	while(row = mysqlw_fetch_row(result))
	{
		name = html_special_chars(mysqlw_field_by_name(row, "name"));
		text = html_special_chars(mysqlw_field_by_name(row, "entry_text"));
		email = html_special_chars(mysqlw_field_by_name(row, "email"));
		date = html_special_chars(mysqlw_field_by_name(row, "entry_date"));
		
		template_set(section, "name", "%s", name);
		template_set(section, "text", "%s", text);
		template_set(section, "email", "%s", email);
		template_set(section, "date", "%s", date);
		template_section_out(section);
	}

	output_pager(template_find_section(tpl, "pager"), page, onpage, overall);	

	mysqlw_free_result(res_overall);
	mysqlw_free_result(result);

	mysqlw_close(mysql);

	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);

	return tpl;
BAIL_OUT:
	if(result)
		mysqlw_free_result(result);
	if(mysql)
		mysqlw_close(mysql);
	if(tpl)
		template_free(tpl);

	return NULL;
}

int main(int argc, char *argv[])
{
	t_cgi_context *ctx = cgi_context_create(NULL);
	int page_no = 0, on_page = 20;
	t_template *tpl, *content;
	struct timespec ts[2];

	POST_VAR(ctx, text);
	POST_VAR(ctx, name);
	POST_VAR(ctx, email);

	GET_VAR(ctx, page);
	GET_VAR(ctx, onpage);
	
	SESSION_INT(ctx, page_no);
	SESSION_INT(ctx, on_page);

	__SELF__ = cgi_getenv(ctx, "SCRIPT_NAME");
	
	clock_gettime(CLOCK_PROF, &ts[0]);

	session_start(ctx);
	
	if(scalar(text) && scalar(name) && scalar(email))
	{
		add_message(name->ff_data, email->ff_data, text->ff_data);
		page_no = 0;
		header_set(ctx, "Location", "guestbook");
		cgi_context_free(ctx);
		exit(0);
	}
	
	if(scalar(page))
	{
		page_no = atoi(page->ff_data);
	}
	
	if(scalar(onpage))
	{
		on_page = atoi(onpage->ff_data);
	}
	
	tpl = template_create("templates/main.html");

	content = output_entries(page_no, on_page);

	clock_gettime(CLOCK_PROF, &ts[1]);

	if(content)
		template_insert(tpl, "content", content);
	else
		template_set(tpl, "content", "Error! couldn't load guestbook entries!");

	template_set(tpl, "gentime", "%f", (double)(ts[1].tv_sec - ts[0].tv_sec) + (double)(ts[1].tv_nsec - ts[0].tv_nsec)/(double)1000000000.0);
	template_out(tpl, ctx->out);

	if(content)
		template_free(content);
	template_free(tpl);

	cgi_context_free(ctx);

	return 0;
}
