#include <stdio.h>
#include <cgi/cgi.h>
#include <cgi/template.h>

int main()
{
	t_cgi_context *ctx = cgi_context_create(NULL);
	int i;
	POST_VAR(ctx, name);
	POST_VAR(ctx, file);
	t_template	*main;
	t_template	*internal;

	cookie_set(ctx, "cookbook", "zero", 1000, NULL);

	headers_out(ctx);

	main = template_create("data/cgi-templates/main.html");

	if(!file)
	{
		internal = template_create("data/cgi-templates/error.html");
		template_set(internal, "message", "Parameter 'file' does not exist!");
		template_set(main, "title", "Error!");
	}
	else
	{
		template_set(main, "title", "Information");
		internal = template_create("data/cgi-templates/message.html");
		template_opt(internal, "is_array", file->is_array);
		template_set(internal, "size", "%ld", file->array_size);

		if(file->is_array)
		{
			for(i = 0; i < file->array_size; i ++)
			{
				if(!file->ff_array[i]->is_file)
				{
					template_set(template_find_section(internal, "element"), "num", "%d", i);
					template_set(template_find_section(internal, "element"), "data", "%s", file->ff_array[i]->ff_data);
				}
				template_section_out(template_find_section(internal, "element"));
			}
		}
		else
		{
			if(!file->is_file)
			{
				template_set(template_find_section(internal, "element"), "num", "%d", 0);
				template_set(template_find_section(internal, "element"), "data", "%s", file->ff_data);
				template_section_out(template_find_section(internal, "element"));
			}
		}
	}

	template_insert(main, "include", internal);
	template_out(main, ctx->out);
	template_free(main);
	template_free(internal);

	cgi_context_free(ctx);
}
