#include <stdio.h>
#include <cgi/cgi.h>

int main()
{
	t_cgi_context *ctx = cgi_context_create(NULL);
	int i;
	char *cookie;

	// Register variables which will be filled by form POST data ("name" && "file")
	POST_VAR(ctx, name);
	POST_VAR(ctx, file);

	// Set some cookie. When you set cookie, it does not appear immediately in
	// cookie_get cookies array, but simply sent to client to set cookie.
	cookie_set(ctx, "some_cookie", "some_cookie_value", 1000, NULL);

	if(!file) // If file is NULL, then the parameter was not found
	{
		fprintf(ctx->out, "Parameter 'file' does not exist!");
	}
	else
	{
		// Parameter was found. Test whether there were several fields with such name.
		// (if yes, an is_array property of field variable will be set to 1)

		// Output "is_array" property of file field. (note, that we don't need to
		// care about headers - they are sent automatically)

		fprintf(ctx->out, "<H1>file->is_array = %d; size = %d</H1><br/>\n", file->is_array, file->array_size);
		if(file->is_array)
		{
			// If array, iterate through all array elements
			for(i = 0; i < file->array_size; i ++)
			{
				// All array elements are fields themselves!
				// If the field is not binary ('file'), output it's value to the browser
				if(!file->ff_array[i]->is_file)
					fprintf(ctx->out, "<H2>file[%d]=%s</H2><br/>\n", i, file->ff_array[i]->ff_data);
			}
		}
		else
		{
			fprintf(ctx->out, "<H2>file=%s</H2><br/>\n", file->ff_data);
		}
	}

	// Try to get a cookie which we have set before
	if(cookie = cookie_get(ctx, "cookbook"))
	{
		fprintf(ctx->out, "<h2>Cookie cookbook == \"%s\"</h2><br/>\n", cookie);
	}

	// Do some cleanup
	cgi_context_free(ctx);
}
