#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <cgi/cgi.h>
#include <cgi/template.h>
//#include <fcgiapp.h>

#define FCGI_SOCK  					"/tmp/fcgi.sock"

int worker(void *req)
{
	int i, bl, j;
	int a = -1;
	char *b = NULL;
	t_cgi_context *ctx = cgi_context_create((FCGX_Request*)req);
	t_template *tpl;
	struct timespec ts[12];

	clock_gettime(CLOCK_PROF, &ts[0]);

	session_start(ctx);

	SESSION_INT(ctx, a);
	SESSION_STRING(ctx, b);

	header_set(ctx, "Content-type", "text/html");

	tpl = template_create("data/templates/content.html");

	if(ctx->session->is_new)
	{
		template_section_out(template_find_section(tpl, "NoValues"));
		b = NULL;
		a = 10;
	}
	else
	{
		template_set(template_find_section(tpl, "Values"), "var_name", "b");
		template_set(template_find_section(tpl, "Values"), "var_value", "%s", b);
		template_section_out(template_find_section(tpl, "Values"));

		template_set(template_find_section(tpl, "Values"), "var_name", "a");
		template_set(template_find_section(tpl, "Values"), "var_value", "%d", a);
		template_section_out(template_find_section(tpl, "Values"));

		a ++;
		a %= 100;
		bl = b ? strlen(b) + 2 : 1;
		b = realloc(b, bl);

		srandomdev();
		
		b[bl - 2] = random() % ('Z' - 'A') + 'A';
		if(random() %2)
			b[bl - 2] = random() % ('z' - 'a') + 'a';
		if(!(random() % 20))
			b[bl - 2] = ' ';
		b[bl - 1] = 0;
	}

	clock_gettime(CLOCK_PROF, &ts[1]);

	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);
	template_out(tpl, ctx->out);
	template_free(tpl);

	cgi_context_free(ctx);
	
	FCGX_Finish_r((FCGX_Request*)req);
	free(req);
}

// ,   
static void listener(int sock) 
{
	int status = 0, rc = 0, trial = 0;
	FCGX_Request *req = NULL;
	fd_set readfds; //, writefds;
	pthread_attr_t attr;

	FD_ZERO ( &readfds );
	FD_SET ( sock, &readfds );

	//  detached?    join,    
	// ,    ,  BSD- POSIX- ,  , , 
	//    
	pthread_attr_init (&attr);
	pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_DETACHED);

	while (1)
	{
		status = select (sock + 1, &readfds, NULL, NULL, NULL);
		if ( status == -1 ) 
		{
			continue;
		}


		// pool -   .   -    
		//    
		//  FCGX_InitRequest (&pool->req, sock, 128);
	//		pool->req.listen_sock = sock;

		//  :-)
		/* 
			 do 
			 { 
			 fd = accept(sock, (struct sockaddr *)&sa, &len); 
			 } 
			 while (fd < 0 && errno == EINTR); */

		if(!(req = malloc(sizeof(FCGX_Request))))
		{
			fprintf(stderr, "Your memory is fucked up!\n");
			continue;
		}
		bzero(req, sizeof(FCGX_Request));
		FCGX_InitRequest(req, sock, 128);
		//req->listen_sock = sock;

		rc = FCGX_Accept_r(req);
		if (rc < 0) 
		{
			// :-D  -     :-)
			fprintf(stderr, "Socket fucked up!\n");
			free(req);
			continue;
		} 

		/*    pool->thread =
					malloc (sizeof (pthread_t)); bzero (pool->thread, sizeof (pthread_t)); */

		pthread_create((void*)req, &attr, (void *)worker, (void *)req );
	}
}

int main()  
{
	int i, flags=0, set=1, fd = fcntl(STDERR_FILENO, F_DUPFD, 0);
	pthread_t avgcounter;
	pthread_t check_expir;
	int sock;
	//  setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char *)&set, sizeof(set));

	FCGX_Init();

	sock = FCGX_OpenSocket(FCGI_SOCK, 2000);

	if(!strchr(FCGI_SOCK, ':')) 
		chmod(FCGI_SOCK, S_IRWXU|S_IRWXG|S_IRWXO);

	if ((flags = fcntl(sock, F_GETFL, 0)) < 0)
	{
		exit (0);
	}

	if (fcntl(sock, F_SETFL, flags | O_NONBLOCK) < 0)
	{
		exit (0);
	}

//	daemon(1, 1);
	listener(sock);

	if(!strchr(FCGI_SOCK, ':')) 
		unlink(FCGI_SOCK);
	
	return 0;  
}

