#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <cgi/template.h>
#include <cgi/html_tree.h>
#include <sys/time.h>
#include <osdep.h>

void cmd_process(t_template *tpl, TAG* node, char **text, char **tagstart, char **tagend, char *param)
{
	char *newtext;
	long len;

	**tagstart = 0;
	len = strlen((*tagend) + 1);

	asprintf(&newtext, "%sCustom command processor: parameter=\"%s\"%s", *text, param, (*tagend)+1);

	*text = *tagstart = *tagend = newtext;
};

int main()
{
	int i, j, k;
	t_template *t;
	t_template *t2;

	// register new command processor
	register_template_command_processor("custom", &cmd_process);

	if(!(t = template_create("data/templates/test.html")))
	{
		printf("Couldn't open file!\n");
		return 21;
	};

	if(!(t2 = template_create("data/templates/test2.html")))
	{
		printf("Couldn't open file!\n");
		return 21;
	};

	template_section_out(template_find_section(t, "hr"));

	for(j = 0; j < 2; j ++)
	{
		for(i = 0; i < 2; i ++)
		{
			template_opt(t, "color", i);
			template_opt(t, "enabled", i);
			template_set(t, "data", "%d", i);
			template_section_out(template_find_section(t, "row"));
		}

		template_set(t, "j", "%d", j);
		template_section_out(template_find_section(t, "table"));
	}

	setAttribute(getElementById(t->document, "check"), "checked", "true");

	template_insert(t, "include", t2);

	template_out(t, stdout);

	template_free(t);

	template_free(t2);

	if(!(t = template_create("data/templates/test.html")))
	{
		printf("Couldn't open file!\n");
		return 21;
	};

	if(!(t2 = template_create("data/templates/test2.html")))
	{
		printf("Couldn't open file!\n");
		return 21;
	};

	template_section_out(template_find_section(t, "hr"));

	for(j = 0; j < 2; j ++)
	{
		for(i = 0; i < 2; i ++)
		{
			template_opt(t, "color", i);
			template_opt(t, "enabled", i);
			template_set(t, "data", "%d", i);
			template_section_out(template_find_section(t, "row"));
		}

		template_set(t, "j", "%d", j);
		template_section_out(template_find_section(t, "table"));
	}

	setAttribute(getElementById(t->document, "check"), "checked", "true");

	template_insert(t, "include", t2);

	template_out(t, stdout);

	template_free(t);

	template_free(t2);

	// free all command processors
	free_template_command_processors();

	return 0;
}
