#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <cgi/cgi.h>
#include <cgi/template.h>
#include <cgi/conn_pool.h>
#include <fcgiapp.h>

#define FCGI_SOCK  					"/tmp/fcgi.sock"
#define isset(var)	(var != NULL)
#define scalar(var) ((var) ? !((var)->is_array) : 0)

char *__SELF__ = NULL;
t_conn_pool *connections = NULL;

int test_user(char *username, char* password)
{
	t_mysql *conn;
	t_mysql_result *res;
	t_mysql_row *row;
	char *sid;
	int id;
	
	if(!(conn = mysqlw_connect("localhost", "root", "", "test")))
		goto BAIL_OUT;

	if(!(res = mysqlw_query(conn, "SELECT * FROM user_tbl WHERE username='%qs' AND password=md5('%qs')", 
							 username, password)))
		goto BAIL_OUT;

	if(row = mysqlw_fetch_row(res))
	{
		sid = mysqlw_field_by_name(row, "id");
		mysqlw_free_result(res);
		mysqlw_close(conn);
		if(sid)
			id = atoi(sid);
		return id;
	}

BAIL_OUT:
	printf("%s", mysql_error(&conn->connection));

	if(res)
		mysqlw_free_result(res);

	mysqlw_close(conn);

	return -1;
}

int worker(void *req)
{
	int user_id = -1, counter = 0;
	t_cgi_context *ctx = cgi_context_create(req);
	t_template *tpl, *content;
	POST_VAR(ctx, username);
	POST_VAR(ctx, password);
	GET_VAR(ctx, action);
	struct timespec ts[2];

	clock_gettime(CLOCK_PROF, &ts[0]);

	SESSION_INT(ctx, user_id);
	SESSION_INT(ctx, counter);

	session_start(ctx);

	tpl = template_create("data/templates/tinycgi/main.html");

	if(user_id == -1)
	{
		if((username) && (password))
		{
			user_id = test_user(username->ff_data, password->ff_data);

			if(user_id != -1)
			{
				header_set(ctx, "Location", "tinycgi");
	
				template_free(tpl);

				counter = 1;
	
				cgi_context_free(ctx);
				return 0;
			}
		}

		template_set(tpl, "title", "Login page");
		template_opt(tpl, "user_status", 0);
		content = template_create("data/templates/tinycgi/login_form.html");
	}
	else
	{
		if(action)
		{
			if(!strcmp(action->ff_data, "logout"))
			{
				user_id = -1;
				
				header_set(ctx, "Location", "tinycgi");
				
				template_free(tpl);
				
				cgi_context_free(ctx);
				
				return 0;
			}
		}

		template_set(tpl, "title", "Welcome!");
		template_opt(tpl, "user_status", 1);
		
		content = template_create("data/templates/tinycgi/welcome.html");
		template_set(content, "session_id", "%s", ctx->session->sessid);
		template_set(content, "user_id", "%d", user_id);
		template_set(content, "counter", "%d", counter);
		
		counter ++;
	}
	
	template_insert(tpl, "content", content);

	clock_gettime(CLOCK_PROF, &ts[1]);

	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);
	template_out(tpl, ctx->out);
	template_free(tpl);
	template_free(content);

	cgi_context_free(ctx);

	FCGX_Finish_r((FCGX_Request*)req);
	free(req);

	return 0;
}

// ,   
void listener(int sock) 
{
	int status = 0, rc = 0, trial = 0;
	FCGX_Request *req = NULL;
	fd_set readfds; //, writefds;
	pthread_attr_t attr;

	FD_ZERO ( &readfds );
	FD_SET ( sock, &readfds );

	//  detached?    join,    
	// ,    ,  BSD- POSIX- ,  , , 
	//    
	pthread_attr_init (&attr);
	pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_DETACHED);

	while (1)
	{
		status = select (sock+1, &readfds, NULL, NULL, NULL);
		if ( status == -1 ) 
		{
			continue;
		}

		if(!(req = malloc(sizeof(FCGX_Request))))
		{
			fprintf(stderr, "Your memory is fucked up!\n");
			continue;
		}

		bzero(req, sizeof(FCGX_Request));
		FCGX_InitRequest(req, sock, 128);
		//req->listen_sock = sock;

		rc = FCGX_Accept_r(req);
		if (rc < 0) 
		{
			// :-D  -     :-)
			fprintf(stderr, "Socket fucked up!\n");
			free(req);
			continue;
		}

		worker(req);
//		pthread_create((void*)req, &attr, (void *)worker, (void *)req );
		req = NULL;
	}
}

int main()  
{
	int i, flags=0, set=1, fd = fcntl(STDERR_FILENO, F_DUPFD, 0);
	pthread_t avgcounter;
	pthread_t check_expir;
	int sock;
	t_mysql *mysql = NULL;
	t_conn_params params = {NULL, 0, "/tmp/mysql.sock"};

	FCGX_Init();

	sock = FCGX_OpenSocket(FCGI_SOCK, 2000);

	if(!strchr(FCGI_SOCK, ':')) 
		chmod(FCGI_SOCK, S_IRWXU|S_IRWXG|S_IRWXO);

	if ((flags = fcntl(sock, F_GETFL, 0)) < 0)
	{
		exit (0);
	}

	if (fcntl(sock, F_SETFL, flags | O_NONBLOCK) < 0)
	{
		exit (0);
	}

	connections = conn_pool_create(50);

	do
	{
		mysql = mysqlw_connect_params(&params, "root", "", "test");
	}while( conn_push(connections, mysql) );

	listener(sock);

	conn_pool_free(connections);

	if(!strchr(FCGI_SOCK, ':')) 
		unlink(FCGI_SOCK);
	
	FCGX_Finish();
	
	return 0;  
}

