#include <cgi/cgi.h>
#include <cgi/template.h>
#include <cgi/mysqlw.h>
int test_user(char *username, char* password)
{
	t_mysql *conn;
	t_mysql_result *res;
	t_mysql_row *row;
	char *sid;
	int id;
	if(!(conn = mysqlw_connect("localhost", "root", "", "test")))
		goto BAIL_OUT;
	if(!(res = mysqlw_query(conn, "SELECT * FROM user_tbl WHERE username='%qs' AND password=md5('%qs')", 
							 username, password))
		goto BAIL_OUT;
	if(row = mysqlw_fetch_row(res))
	{
		sid = mysqlw_field_by_name(row, "id");
		mysqlw_free_result(res);
		mysqlw_close(conn);
		if(sid)
			id = atoi(sid);
		return id;
	}
BAIL_OUT:
	if(res)
		mysqlw_free_result(res);
	mysqlw_close(conn);
	return -1;
}
int main()
{
	int user_id = -1, counter = 0;
	t_cgi_context *ctx = cgi_context_create(NULL);
	t_template *tpl, *content;
	POST_VAR(ctx, username);
	POST_VAR(ctx, password);
	GET_VAR(ctx, action);
	struct timespec ts[2];
	clock_gettime(CLOCK_PROF, &ts[0]);
	SESSION_INT(ctx, user_id);
	SESSION_INT(ctx, counter);
	session_start(ctx);
	tpl = template_create("data/templates/tinycgi/main.html");
	if(user_id == -1)
	{
		if((username) && (password))
		{
			user_id = test_user(username->ff_data, password->ff_data);
			if(user_id != -1)
			{
				header_set(ctx, "Location", "tinycgi");
				template_free(tpl);
				counter = 1;
				cgi_context_free(ctx);
				return 0;
			}
		}
		template_set(tpl, "title", "Login page");
		template_opt(tpl, "user_status", 0);
		content = template_create("data/templates/tinycgi/login_form.html");
	}
	else if(user_id != -1)
	{
		if(action)
		{
			if(!strcmp(action->ff_data, "logout"))
			{
				user_id = -1;
				header_set(ctx, "Location", "tinycgi");
				template_free(tpl);
				cgi_context_free(ctx);
				return 0;
			}
		}
		template_set(tpl, "title", "Welcome!");
		template_opt(tpl, "user_status", 1);
		content = template_create("data/templates/tinycgi/welcome.html");
		template_set(content, "session_id", "%s", ctx->session->sessid);
		template_set(content, "user_id", "%d", user_id);
		template_set(content, "counter", "%d", counter);
		counter ++;
	}
	template_insert(tpl, "content", content);
	clock_gettime(CLOCK_PROF, &ts[1]);
	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);
	template_out(tpl, ctx->out);
	template_free(tpl);
	template_free(content);
	cgi_context_free(ctx);
	return 0;
}
