#include <stdio.h>
#include <stdlib.h>
#include <cgi/cgi.h>
#include <cgi/template.h>
#include <cgi/mysqlw.h>

int test_user(char *username, char* password)
{
	t_mysql *conn;
	t_mysql_result *res;
	t_mysql_row *row;
	char *sid;
	int id;
	
	conn = mysqlw_connect("localhost", "root", "", "test");

	res = mysqlw_query(conn, "SELECT * FROM user_tbl WHERE username='%qs' AND password=md5('%qs')", 
							 username, password);

	if(row = mysqlw_fetch_row(res))
	{
		sid = mysqlw_field_by_name(row, "id");
		mysqlw_free_result(res);
		mysqlw_close(conn);
		if(sid)
			id = atoi(sid);
		return id;
	}

BAIL_OUT:
	mysqlw_close(conn);

	if(res)
		mysqlw_free_result(res);

	return -1;
}

int main()
{
	int user_id = -1, counter = 0;
	t_cgi_context *ctx = cgi_context_create(NULL);
	t_template *tpl, *content;
	POST_VAR(ctx, username);
	POST_VAR(ctx, password);
	GET_VAR(ctx, action);
	struct timespec ts[2];

	clock_gettime(CLOCK_PROF, &ts[0]);

	// Register variable to save.
	// Variables are stored on server side, therefore it is
	// securely enough to save an store the user id.
	SESSION_INT(ctx, user_id);
	SESSION_INT(ctx, counter);

	// Starting session
	session_start(ctx);

	// Open the main template
	tpl = template_create("data/templates/tinycgi/main.html");

	// If user is not logged in, and form is submitted,
	// check the username and password to match ones, stored in database.
	if((user_id == -1) && (username) && (password))
	{
		// Check username and password and return user id, or -1 on fail.
		user_id = test_user(username->ff_data, password->ff_data);

		// If username and password match, redirect user to the
		// same page with no POST data (this is to avoid re-submitting
		// form data if the page is being refreshed).
		if(user_id != -1)
		{
			header_set(ctx, "Location", "tinycgi");

			// Clean up template
			template_free(tpl);

			// Initialize counter
			counter = 1;

			// Clean up resources, and save session variables
			cgi_context_free(ctx);
			return 0;
		}
	}
	else if((user_id != -1) && (action))
	{
		if(!strcmp(action->ff_data, "logout"))
		{
			user_id = -1;
			
			header_set(ctx, "Location", "tinycgi");
			
			// Clean up template
			template_free(tpl);
			
			// Initialize counter
			counter = 0;
			
			// Clean up resources, and save session variables
			cgi_context_free(ctx);
			
			return 0;
		}
	}
	
	// Check whether user is logged in, to act accordingly.
	if(user_id == -1)
	{
		// Set title to "Login page" and user status to 0 (not logged in)
		template_set(tpl, "title", "Login page");
		template_opt(tpl, "user_status", 0);

		// Set the content part of the template to login form
		content = template_create("data/templates/tinycgi/login_form.html");
	}
	else // If user is logged in
	{
		// Set title to "Welcome!", and user status to 1 (logged in)
		template_set(tpl, "title", "Welcome!");
		template_opt(tpl, "user_status", 1);
		
		// Set the content part of the template to welcome page template,
		// and fill in template placeholders with actual values.
		content = template_create("data/templates/tinycgi/welcome.html");
		template_set(content, "session_id", "%s", ctx->session->sessid);
		template_set(content, "user_id", "%d", user_id);
		template_set(content, "counter", "%d", counter);
		
		// Increment the counter
		counter ++;
	}

	// Insert the content template into {content} placeholder
	// (menu part will be changed automatically)
	template_insert(tpl, "content", content);

	clock_gettime(CLOCK_PROF, &ts[1]);

	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);

	// Output template	
	template_out(tpl, ctx->out);

	// Clean up templates
	template_free(tpl);
	template_free(content);

	// Clean up resources, and save session variables
	cgi_context_free(ctx);

	return 0;
}
