#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <cgi/cgi.h>
#include <cgi/template.h>
#include <cgi/conn_pool.h>
#include <fcgiapp.h>

#define FCGI_SOCK  					"/tmp/fcgi.sock"
#define isset(var)	(var != NULL)
#define scalar(var) ((var) ? !((var)->is_array) : 0)

char *__SELF__ = NULL;
t_conn_pool *connections = NULL;

struct s_page
{
	int is_first;
	int is_last;
	int is_active;
	int is_ellipse;
	int no;
};

void add_message(char *name, char *email, char *text)
{
	t_mysql *mysql;
	t_conn_params params = {"localhost", 0, "/tmp/mysql.sock"};

	mysql = conn_pop(connections);

	if(!mysql)
		mysql = mysqlw_connect_params(&params, "root", "", "test");

	mysqlw_query(mysql, "INSERT INTO gb_entries(id, name, email, entry_text, entry_date) "
				 "VALUES(NULL, '%qs', '%qs', '%qs', NOW())", name, email, text);

	conn_push(connections, mysql);
};

void output_pager(t_template *tpl, int page, int onpage, long records)
{
#define	RANGE	2
#define SIZE	(RANGE*4+5)
	struct s_page pages[SIZE];
	int i, j;
	long overall;
	t_tpl_section *pager;

	overall = (records / onpage) + (records % onpage ? 1 : 0);

	if((onpage - records) >= 0)
	{
		return;
	}

	for(i = 0, j = 0; i < overall; i ++)
	{
		if((i>RANGE) && ((overall-1-i)>RANGE) && (abs(i-page)>RANGE) &&
			!((page<(RANGE*2+2)) && (i<(RANGE*3+3))) && 
			!(((overall-1-page)<(RANGE*2+2)) && ((overall-1-i)<(RANGE*3+3))))
			continue;

		bzero(&pages[j], sizeof(pages[j]));

		if(j > 0)
		{
			if((pages[j-1].no != (i - 1)) && !pages[j-1].is_ellipse)
			{
				pages[j].is_ellipse = 1;
				j ++;
				bzero(&pages[j], sizeof(pages[j]));
			}
		}

		pages[j].is_first = (i == 0);
		pages[j].is_last = (i == (overall - 1));
		pages[j].is_active = (i == page);
		pages[j].no = i;
		j ++;
	}
	
	template_set(tpl, "script", "%s", __SELF__);

	template_set(tpl, "nextpage", "%d", page+1);
	template_set(tpl, "prevpage", "%d", page-1);

	template_set(tpl, "onpage", "%d", onpage);

	template_opt(tpl, "prevvisible", page > 0);
	template_opt(tpl, "nextvisible", page < (overall - 1));

	pager = template_find_section(tpl, "page");
	
	for(i = 0; i < SIZE; i ++)
	{
		template_set(pager, "script", "%s", __SELF__);
		template_set(pager, "onpage", "%d", onpage);
		template_set(pager, "pageno", "%d", pages[i].no);
		template_set(pager, "pagenum", "%d", pages[i].no + 1);
		template_opt(pager, "active", pages[i].is_active);
		template_opt(pager, "ellipse", pages[i].is_ellipse);
		template_section_out(pager);

		if(pages[i].is_last)
			break;
	}
	
	template_section_out(tpl);
};

t_template *output_entries(int page, int onpage)
{
	t_template *tpl = NULL;
	t_tpl_section *section;
	t_mysql *mysql = NULL;
	t_mysql_result *result = NULL, *res_overall = NULL;
	t_mysql_row *row;
	long overall;
	char *name, *email, *text, *date;
	t_conn_params params = {NULL, 0, "/tmp/mysql.sock"};
	struct timespec ts[2];

	if(!(tpl = template_create("templates/guestbook.html")))
		goto BAIL_OUT;

	clock_gettime(CLOCK_PROF, &ts[0]);

	mysql = conn_pop(connections);

	if(!mysql)
		mysql = mysqlw_connect_params(&params, "root", "", "test");

	if(!mysql)
		goto BAIL_OUT;

	result = mysqlw_query(mysql, "SELECT SQL_CALC_FOUND_ROWS * FROM gb_entries "
								 "ORDER BY entry_date DESC LIMIT %d, %d", page * onpage, onpage);
	if(!result)
		goto BAIL_OUT;

	if(!(res_overall = mysqlw_query(mysql, "SELECT FOUND_ROWS() as overall")))
		goto BAIL_OUT;

	if(!(row = mysqlw_fetch_row(res_overall)))
		goto BAIL_OUT;

	overall = atol(mysqlw_field_by_name(row, "overall"));

	if(!(section = template_find_section(tpl, "post")))
		goto BAIL_OUT;
	
	while(row = mysqlw_fetch_row(result))
	{
		name = mysqlw_field_by_name(row, "name");
		text = mysqlw_field_by_name(row, "entry_text");
		email = mysqlw_field_by_name(row, "email");
		date = mysqlw_field_by_name(row, "entry_date");
		
		template_set(section, "name", "%s", name);
		template_set(section, "text", "%s", text);
		template_set(section, "email", "%s", email);
		template_set(section, "date", "%s", date);
		template_section_out(section);
	}

	output_pager(template_find_section(tpl, "pager"), page, onpage, overall);	

	mysqlw_free_result(res_overall);
	mysqlw_free_result(result);

	clock_gettime(CLOCK_PROF, &ts[1]);

	conn_push(connections, mysql);

	template_set(tpl, "gentime", "%f", (ts[1].tv_sec - ts[0].tv_sec) + (float)(ts[1].tv_nsec - ts[0].tv_nsec)/1000000000.0);

	return tpl;

BAIL_OUT:
	if(result)
		mysqlw_free_result(result);
	if(res_overall)
		mysqlw_free_result(res_overall);
	if(mysql)
		conn_push(connections, mysql);
	if(tpl)
		template_free(tpl);

	return NULL;
}

int worker(void *req)
{
	t_cgi_context *ctx = cgi_context_create((FCGX_Request*)req);
	int page_no = 0, on_page = 20;
	t_template *tpl, *content = NULL;
	struct timespec ts[2];

	POST_VAR(ctx, text);
	POST_VAR(ctx, name);
	POST_VAR(ctx, email);

	GET_VAR(ctx, page);
	GET_VAR(ctx, onpage);
	
	SESSION_INT(ctx, page_no);
	SESSION_INT(ctx, on_page);

	if(!__SELF__)
		__SELF__ = strdup(cgi_getenv(ctx, "SCRIPT_NAME"));

	session_start(ctx);

	clock_gettime(CLOCK_PROF, &ts[0]);

	if(scalar(text) && scalar(name) && scalar(email))
	{
		add_message(name->ff_data, email->ff_data, text->ff_data);
		page_no = 0;
		header_set(ctx, "Location", "tinyfcgi");//__SELF__);
		cgi_context_free(ctx);

		FCGX_Finish_r((FCGX_Request*)req);
		free(req);

		return 0;
	}
	
	if(scalar(page))
	{
		page_no = atoi(page->ff_data);
	}
	
	if(scalar(onpage))
	{
		on_page = atoi(onpage->ff_data);
	}

	if(on_page == 0)
		on_page = 1;

	tpl = template_create("templates/main.html");

	content = output_entries(page_no, on_page);

	if(content)
		template_insert(tpl, "content", content);
	else
		template_set(tpl, "content", "Error! couldn't load guestbook entries!");

	clock_gettime(CLOCK_PROF, &ts[1]);

	template_set(tpl, "gentime", "%f", (double)(ts[1].tv_sec - ts[0].tv_sec) + (double)(ts[1].tv_nsec - ts[0].tv_nsec)/(double)1000000000.0);
	template_out(tpl, ctx->out);

	if(content)
		template_free(content);

	template_free(tpl);

	cgi_context_free(ctx);

	FCGX_Finish_r((FCGX_Request*)req);
	free(req);

	return 0;
}

// ,   
void listener(int sock) 
{
	int status = 0, rc = 0, trial = 0;
	FCGX_Request *req = NULL;
	fd_set readfds; //, writefds;
	pthread_attr_t attr;

	FD_ZERO ( &readfds );
	FD_SET ( sock, &readfds );

	//  detached?    join,    
	// ,    ,  BSD- POSIX- ,  , , 
	//    
	pthread_attr_init (&attr);
	pthread_attr_setdetachstate (&attr, PTHREAD_CREATE_DETACHED);

	while (1)
	{
		status = select (sock+1, &readfds, NULL, NULL, NULL);
		if ( status == -1 ) 
		{
			continue;
		}

		if(!(req = malloc(sizeof(FCGX_Request))))
		{
			fprintf(stderr, "Your memory is fucked up!\n");
			continue;
		}

		bzero(req, sizeof(FCGX_Request));
		FCGX_InitRequest(req, sock, 128);
		//req->listen_sock = sock;

		rc = FCGX_Accept_r(req);
		if (rc < 0) 
		{
			// :-D  -     :-)
			fprintf(stderr, "Socket fucked up!\n");
			free(req);
			continue;
		}

		worker(req);
//		pthread_create((void*)req, &attr, (void *)worker, (void *)req );
		req = NULL;
	}
}

int main()  
{
	int i, flags=0, set=1, fd = fcntl(STDERR_FILENO, F_DUPFD, 0);
	pthread_t avgcounter;
	pthread_t check_expir;
	int sock;
	t_mysql *mysql = NULL;
	t_conn_params params = {NULL, 0, "/tmp/mysql.sock"};

	FCGX_Init();

	sock = FCGX_OpenSocket(FCGI_SOCK, 2000);

	if(!strchr(FCGI_SOCK, ':')) 
		chmod(FCGI_SOCK, S_IRWXU|S_IRWXG|S_IRWXO);

	if ((flags = fcntl(sock, F_GETFL, 0)) < 0)
	{
		exit (0);
	}

	if (fcntl(sock, F_SETFL, flags | O_NONBLOCK) < 0)
	{
		exit (0);
	}

	connections = conn_pool_create(50);

	do
	{
		mysql = mysqlw_connect_params(&params, "root", "", "test");
	}while( conn_push(connections, mysql) );

	listener(sock);

	conn_pool_free(connections);

	if(!strchr(FCGI_SOCK, ':')) 
		unlink(FCGI_SOCK);
	
	FCGX_Finish();
	
	return 0;  
}

