#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <osdep.h>
//#include <cgi/cgi_config.h>

#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

#ifndef HAVE_ASPRINTF
int asprintf(char **str, char *fmt, ...)
{
	va_list	vl;
	char *allocated = NULL;
	int to_allocate = 0;

	va_start(vl, fmt);
	
	to_allocate = vsnprintf(NULL, 0, fmt, vl);
	
	allocated = (char*)malloc(to_allocate + 1);
	
	if(!allocated)
	{
		return -1;
	}
	
	vsnprintf(allocated, to_allocate + 1, fmt, vl);
	
	va_end(vl);
	
	*str = allocated;
	return to_allocate;
}
#endif

#ifndef HAVE_STRCASESTR
char *strcasestr(register char *where, char *what)
{
	char c1[] = {0, 0};
	char c2[] = {0, 0};
	
	*c1 = *what;
	*c2 = *what;
	
#ifdef	HAVE_STRUPR
	strupr(c1);
#else
#	ifdef HAVE__STRUPR
	_strupr(c1);
#	endif
#endif

#ifdef	HAVE_STRLWR
	strlwr(c2);
#else
#	ifdef HAVE__STRLWR
	_strlwr(c2);
#	endif
#endif

	while(*where)
	{
		while(*where && *where != *c1 && *where != *c2)
			where ++;
#ifdef	HAVE_STRCASECMP
		if(!strcasecmp(where, what))
#else
#	ifdef	HAVE_STRICMP
		if(!stricmp(where, what))
#	endif
#endif
			return where;
	}
}
#endif

char *dirname_r(char *filename)
{
	char *lastsep;
	char *dname;
	long len;

	if((lastsep = strrchr(filename, DIR_SEPARATOR)))
	{
		len = lastsep - filename;
		dname = malloc(len + 1);
		memcpy(dname, filename, len);
		dname[len] = '\0';
	}
	else
	{
		dname = malloc(2);
		dname[0] = '.';
		dname[1] = '\0';
	}

	return dname;
}
