/*
 * Copyright (c) 2002 RusNet #c channel
 * All rights reserved
 *
 * This file is a part of mproxy package, and contains parts common for the
 * client and bouncer
 * See descr.txt for more details
 *
 * $Id$
 */

#include <stdio.h>
#include <string.h>

#include "common.h"

/*
 * Parse the message header, filling the structure passed
 * return 0 on success, -1 on error
 */
int
parseheader(char *line, struct header *sp)
{
	static char server[BSIZ], email[BSIZ];
	int port;
	int rval = -1;
	
	if (sscanf(line, MAGIC " %d/%d/%[^/]/%[^/]/%d",
	   &sp->msgno, &sp->id, email, server, &port) == 5) {
		rval = 0;
		sp->server = server;
		sp->email = email;
		sp->port = (short) port;
	}

	return (rval);
}

/*
 * Remove the connection thread from a linked list
 */
void
delnode(struct tdata *tp, struct tdata **head)
{
	struct tdata *prev, *tmp;

	if (*head == NULL)
		return;

	if (tp->id == (*head)->id) {
		*head = tp->next;
	} else {
		for (prev = *head, tmp = prev->next; tmp != NULL; ) {
			if (tmp->id == tp->id) {
				prev->next = tmp->next;
				break;
			}
			prev = tmp;
			tmp = tmp->next;
		}
	}
}

/*
 * Add new connection to the connection list pointed by head
 */
void
addnode(struct tdata *tp, struct tdata **head)
{
	tp->next = *head;
	*head = tp;
}

/*
 * Crypt the data by mixing neighbour bytes and xoring them
 * calling this function second time  will decrypt the data
 * XXX the algo is very simple and trivial to reverse
 */
void
cryptdecrypt(unsigned char *p, int len)
{
	const unsigned char *xor = "http://www.c.org.ua";
	int xorlen, i;

	for (i = 0, xorlen = strlen(xor); i < len; i++)
		p[i] ^= xor[i % xorlen];
}
