/*
 * Copyright (c) 2002 RusNet #c channel
 * All rights reserved
 *
 * This file is a part of mproxy package, and contains parts common for the
 * client and bouncer
 * See descr.txt for more details
 *
 * $Id$
 */

#ifndef __COMMON__H__
#define __COMMON__H__

#ifdef __WIN32__
#include <winsock.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif /* __WIN32__ */

#define BSIZ		2048	/*
				 * buffer size, make larger then
				 * the Ethernet MTU size (1518 bytes)
				 */
#define MAGIC		"kiev"	/* magic word prepended to every msg */

/*
 * header for every message
 */
struct header {
	unsigned msgno;		/* message number (autoincrement) */
	unsigned id;		/* identifier of receiver process */
	char *email;		/* local email */
	char *server;		/* remote server */
	short port;		/* remote port */
	
};

/*
 * this structure identifies a connection thread.
 * All active connection are organized in a singly linked list, each
 * member is identified by the thread id.
 */
struct tdata {
	struct tdata *next;
	unsigned id;		/* thread id */
	int sock;		/* accept() -ed socket */
	size_t socklen;
	struct sockaddr_in sa;	/* peer's socket address */
	unsigned msgno;		/* message counter */
	
	void *data;		/*
				 * data. on windows client, ptr to a global
				 * structure. on unix, a string representing
				 * email address to reply to
				 */
};

/*
 * Loop over each connection. it is safe to delete a connection
 * head is the pointer to the list head, tp, tmp are of type  struct tdata *
 */
#define FOREACH_CONN_SAFE(head,tp,tmp)				\
	for (tp = head, tmp = tp ? tp->next : NULL;		\
	    tp != NULL; tp = tmp, tmp = tmp ? tmp->next : NULL) \


extern int parseheader(char *line, struct header *sp);
extern void delnode(struct tdata *tp, struct tdata **head);
extern void addnode(struct tdata *tp, struct tdata **head);
extern void cryptdecrypt(unsigned char *p, int len);

#endif /* __COMMON__H__ */
